"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepLogistics = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _documentation_links = require("../../../services/documentation_links");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps/step_logistics.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const indexPatternIllegalCharacters = _public2.indexPatterns.ILLEGAL_CHARACTERS_VISIBLE.join(' ');
const indexIllegalCharacters = _shared_imports.indices.INDEX_ILLEGAL_CHARACTERS_VISIBLE.join(' ');
class StepLogistics extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      cronFocus: false
    });
    (0, _defineProperty2.default)(this, "showAdvancedCron", () => {
      this.setState({
        cronFocus: true
      });
      const {
        onFieldsChange
      } = this.props;
      onFieldsChange({
        isAdvancedCronVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "hideAdvancedCron", () => {
      this.setState({
        cronFocus: true
      });
      const {
        onFieldsChange,
        fields
      } = this.props;
      const {
        simpleRollupCron
      } = fields;
      onFieldsChange({
        isAdvancedCronVisible: false,
        // Restore the last value of the simple cron editor.
        rollupCron: simpleRollupCron
      });
    });
    (0, _defineProperty2.default)(this, "renderErrors", () => {
      const {
        areStepErrorsVisible,
        hasErrors
      } = this.props;
      if (!areStepErrorsVisible || !hasErrors) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_components.StepError, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 527,
          columnNumber: 12
        }
      });
    });
  }
  renderIndexPatternHelpText() {
    const {
      isValidatingIndexPattern,
      hasMatchingIndices
    } = this.props;
    if (!isValidatingIndexPattern && hasMatchingIndices) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "success",
        "data-test-subj": "fieldIndexPatternSuccessMessage",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpHasMatchesLabel",
        defaultMessage: "Success! Index pattern has matching indices.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 13
        }
      })));
    }
    let indexPatternValidationStatus;
    if (isValidatingIndexPattern) {
      indexPatternValidationStatus = /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpSearchingLabel",
        defaultMessage: "Looking for matching indices...",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 11
        }
      }));
    } else {
      indexPatternValidationStatus = /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpMustMatchLabel",
        defaultMessage: "Index pattern must match at least one index that is not a rollup.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    }, indexPatternValidationStatus, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpAllowLabel",
      defaultMessage: "Use a wildcard ({asterisk}) to match multiple indices.",
      values: {
        asterisk: /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 33
          }
        }, "*")
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPattern.helpDisallowLabel",
      defaultMessage: "Spaces and the characters {characterList} are not allowed.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 124,
            columnNumber: 38
          }
        }, indexPatternIllegalCharacters)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    })));
  }
  renderCronEditor() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors
    } = this.props;
    const {
      rollupCron,
      cronFrequency,
      isAdvancedCronVisible,
      fieldToPreferredValueMap
    } = fields;
    const {
      rollupCron: errorRollupCron
    } = fieldErrors;
    if (isAdvancedCronVisible) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.create.stepLogistics.fieldCronLabel",
          defaultMessage: "Cron expression",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 15
          }
        }),
        error: errorRollupCron,
        isInvalid: Boolean(areStepErrorsVisible && errorRollupCron),
        helpText: /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 151,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation_links.documentationLinks.apis.cronExpressions,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 152,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.create.stepLogistics.fieldCron.helpReferenceLinkLabel",
          defaultMessage: "Learn more about cron expressions",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 153,
            columnNumber: 19
          }
        }))),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        autoFocus: this.state.cronFocus,
        value: rollupCron,
        onChange: e => onFieldsChange({
          rollupCron: e.target.value
        }),
        isInvalid: Boolean(areStepErrorsVisible && errorRollupCron),
        fullWidth: true,
        "data-test-subj": "rollupAdvancedCron",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: this.hideAdvancedCron,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionSchedule.buttonBasicLabel",
        defaultMessage: "Create basic interval",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 15
        }
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_public.CronEditor, {
      autoFocus: this.state.cronFocus,
      fieldToPreferredValueMap: fieldToPreferredValueMap,
      cronExpression: rollupCron,
      frequency: cronFrequency,
      onChange: ({
        cronExpression,
        frequency,
        fieldToPreferredValueMap
      }) => onFieldsChange({
        rollupCron: cronExpression,
        simpleRollupCron: cronExpression,
        cronFrequency: frequency,
        fieldToPreferredValueMap
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.showAdvancedCron,
      "data-test-subj": "rollupShowAdvancedCronLink",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.sectionSchedule.buttonAdvancedLabel",
      defaultMessage: "Create cron expression",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 13
      }
    }))));
  }
  render() {
    const {
      fields,
      onFieldsChange,
      areStepErrorsVisible,
      fieldErrors,
      isValidatingIndexPattern,
      indexPatternAsyncErrors
    } = this.props;
    const {
      id,
      indexPattern,
      rollupIndex,
      rollupPageSize,
      rollupDelay
    } = fields;
    const {
      id: errorId,
      indexPattern: errorIndexPattern,
      rollupIndex: errorRollupIndex,
      rollupPageSize: errorRollupPageSize,
      rollupDelay: errorRollupDelay
    } = fieldErrors;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateLogisticsTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogisticsTitle",
      defaultMessage: "Logistics",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.logisticsDescription",
      defaultMessage: "Define how to run the rollup job and when to index the documents.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: _documentation_links.documentationLinks.apis.createRollupJobsRequest,
      target: "_blank",
      iconType: "question",
      "data-test-subj": "rollupJobCreateLogisticsDocsButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepLogistics.readDocsButtonLabel",
      defaultMessage: "Logistics docs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionIdTitle",
        defaultMessage: "Name",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 286,
          columnNumber: 19
        }
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionIdDescription",
        defaultMessage: "This name will be used as a unique identifier for this rollup job.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 294,
          columnNumber: 15
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIdLabel",
        defaultMessage: "Name",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 303,
          columnNumber: 17
        }
      }),
      error: errorId,
      isInvalid: Boolean(areStepErrorsVisible && errorId),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: Boolean(areStepErrorsVisible && errorId),
      value: id,
      onChange: e => onFieldsChange({
        id: e.target.value
      }),
      fullWidth: true,
      "data-test-subj": "rollupJobName",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDataFlowTitle",
        defaultMessage: "Data flow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 326,
          columnNumber: 19
        }
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDataFlowDescription",
        defaultMessage: "Which indices do you want to roll up and where do you want to store the data?",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 15
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldIndexPatternLabel",
        defaultMessage: "Index pattern",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 17
        }
      }),
      error: isValidatingIndexPattern ? undefined : errorIndexPattern || indexPatternAsyncErrors,
      isInvalid: Boolean(areStepErrorsVisible && errorIndexPattern) || Boolean(indexPatternAsyncErrors),
      helpText: this.renderIndexPatternHelpText(),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: indexPattern,
      onChange: e => onFieldsChange({
        indexPattern: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorIndexPattern) || Boolean(indexPatternAsyncErrors),
      isLoading: isValidatingIndexPattern,
      fullWidth: true,
      "data-test-subj": "rollupIndexPattern",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 358,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldRollupIndexLabel",
        defaultMessage: "Rollup index name",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 373,
          columnNumber: 17
        }
      }),
      error: errorRollupIndex,
      isInvalid: Boolean(areStepErrorsVisible && errorRollupIndex),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldRollupIndex.helpDisallowLabel",
        defaultMessage: "Spaces, commas, and the characters {characterList} are not allowed.",
        values: {
          characterList: /*#__PURE__*/_react.default.createElement("strong", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 384,
              columnNumber: 44
            }
          }, indexIllegalCharacters)
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 381,
          columnNumber: 17
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: rollupIndex,
      onChange: e => onFieldsChange({
        rollupIndex: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorRollupIndex),
      fullWidth: true,
      "data-test-subj": "rollupIndexName",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 401,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 402,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionScheduleTitle",
        defaultMessage: "Schedule",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 403,
          columnNumber: 19
        }
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionScheduleDescription",
        defaultMessage: "How often do you want to roll up the data?",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 411,
          columnNumber: 15
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 399,
        columnNumber: 11
      }
    }, this.renderCronEditor()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 423,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h4", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 424,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionPageSizeTitle",
        defaultMessage: "How many documents do you want to roll up at a time?",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 425,
          columnNumber: 19
        }
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionPageSizeDescription",
        defaultMessage: "A larger page size will roll up data quicker, but requires more memory.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 433,
          columnNumber: 15
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.fieldPageSizeLabel",
        defaultMessage: "Page size",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 442,
          columnNumber: 17
        }
      }),
      error: errorRollupPageSize,
      isInvalid: Boolean(areStepErrorsVisible && errorRollupPageSize),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 440,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: rollupPageSize ? Number(rollupPageSize) : '',
      onChange: e => onFieldsChange({
        rollupPageSize: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorRollupPageSize),
      fullWidth: true,
      min: 0,
      "data-test-subj": "rollupPageSize",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 464,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h4", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 465,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDelayTitle",
        defaultMessage: "How long should the rollup job wait before rolling up new data?",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 466,
          columnNumber: 19
        }
      }))),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepLogistics.sectionDelayDescription",
        defaultMessage: "A latency buffer will delay rolling up data. This will yield a higher-fidelity rollup by allowing for variable ingest latency. By default, the rollup job attempts to roll up all data that is available.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 474,
          columnNumber: 15
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldDelayLabel",
        defaultMessage: "Latency buffer (optional)",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 485,
          columnNumber: 17
        }
      }),
      error: errorRollupDelay,
      isInvalid: Boolean(areStepErrorsVisible && errorRollupDelay),
      helpText: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 493,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 494,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.create.stepDateHistogram.fieldDelay.helpExampleLabel",
        defaultMessage: "Example values: 30s, 20m, 24h, 2d, 1w, 1M",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 495,
          columnNumber: 21
        }
      }))),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 483,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: rollupDelay || '',
      onChange: e => onFieldsChange({
        rollupDelay: e.target.value
      }),
      isInvalid: Boolean(areStepErrorsVisible && errorRollupDelay),
      fullWidth: true,
      "data-test-subj": "rollupDelay",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 504,
        columnNumber: 15
      }
    })))), this.renderErrors());
  }
}
exports.StepLogistics = StepLogistics;
(0, _defineProperty2.default)(StepLogistics, "propTypes", {
  fields: _propTypes.default.object.isRequired,
  onFieldsChange: _propTypes.default.func.isRequired,
  fieldErrors: _propTypes.default.object.isRequired,
  hasErrors: _propTypes.default.bool.isRequired,
  areStepErrorsVisible: _propTypes.default.bool.isRequired,
  isValidatingIndexPattern: _propTypes.default.bool.isRequired,
  hasMatchingIndices: _propTypes.default.bool.isRequired,
  indexPatternAsyncErrors: _propTypes.default.array
});