"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortChanged = exports.pageSizeChanged = exports.pageChanged = exports.filterChanged = void 0;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterChanged = ({
  filter
}) => dispatch => {
  dispatch({
    type: _action_types.FILTER_CHANGED,
    payload: {
      filter
    }
  });
};
exports.filterChanged = filterChanged;
const pageChanged = ({
  pageNumber
}) => dispatch => {
  dispatch({
    type: _action_types.PAGE_CHANGED,
    payload: {
      pageNumber
    }
  });
};
exports.pageChanged = pageChanged;
const pageSizeChanged = ({
  pageSize
}) => dispatch => {
  dispatch({
    type: _action_types.PAGE_SIZE_CHANGED,
    payload: {
      pageSize
    }
  });
};
exports.pageSizeChanged = pageSizeChanged;
const sortChanged = ({
  sortField,
  isSortAscending
}) => dispatch => {
  dispatch({
    type: _action_types.SORT_CHANGED,
    payload: {
      sortField,
      isSortAscending
    }
  });
};
exports.sortChanged = sortChanged;