"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeOperation = mergeOperation;
var _jsonSchemaRefParser = require("@apidevtools/json-schema-ref-parser");
var _deepmerge = _interopRequireDefault(require("deepmerge"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function mergeOperation(pathToSpecOrSpec, operation) {
  if (typeof pathToSpecOrSpec === 'string') {
    Object.assign(operation, (0, _deepmerge.default)(operation, await (0, _jsonSchemaRefParser.dereference)(pathToSpecOrSpec)));
  } else {
    Object.assign(operation, (0, _deepmerge.default)(operation, pathToSpecOrSpec));
  }
}