"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isModifiedOrPrevented = exports.TagTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/management/components/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tablePagination = {
  initialPageSize: 20,
  pageSizeOptions: [5, 10, 20, 50]
};
const sorting = {
  sort: {
    field: 'name',
    direction: 'asc'
  }
};
const isModifiedOrPrevented = event => event.metaKey || event.altKey || event.ctrlKey || event.shiftKey || event.defaultPrevented;
exports.isModifiedOrPrevented = isModifiedOrPrevented;
const TagTable = ({
  loading,
  capabilities,
  tags,
  initialQuery,
  allowSelection,
  onQueryChange,
  selectedTags,
  onSelectionChange,
  onShowRelations,
  getTagRelationUrl,
  actionBar,
  actions
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const connectionsLabel = _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.connections', {
    defaultMessage: 'Connections'
  });
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.name', {
      defaultMessage: 'Name'
    }),
    sortable: tag => tag.name,
    'data-test-subj': 'tagsTableRowName',
    render: (name, tag) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.TagBadge, {
        tag: tag,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 13
        }
      }), tag.managed && /*#__PURE__*/_react.default.createElement("div", {
        css: {
          marginLeft: euiTheme.size.s
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "lock",
        content: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.managedTagTooltip', {
          defaultMessage: 'This {tagName} is managed by Elastic and cannot be deleted, edited, or assigned to objects.',
          values: {
            tagName: tag.name
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 17
        }
      })));
    }
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.description', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    'data-test-subj': 'tagsTableRowDescription'
  }, {
    field: 'relationCount',
    name: connectionsLabel,
    sortable: tag => tag.relationCount,
    'data-test-subj': 'tagsTableRowConnections',
    render: (relationCount, tag) => {
      if (relationCount < 1) {
        return undefined;
      }
      const columnText = /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "tagsTableRowConnectionsText",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.savedObjectsTagging.management.table.content.connectionCount",
        defaultMessage: "{relationCount, plural, one {1 saved object} other {# saved objects}}",
        values: {
          relationCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      }));
      return capabilities.viewConnections ?
      /*#__PURE__*/
      // eslint-disable-next-line @elastic/eui/href-or-on-click
      _react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "tagsTableRowConnectionsLink",
        href: getTagRelationUrl(tag),
        onClick: e => {
          if (!isModifiedOrPrevented(e) && e.button === 0) {
            e.preventDefault();
            onShowRelations(tag);
          }
        },
        "aria-label": _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.connectionsAriaLabel', {
          defaultMessage: `{connectionsLabel} of {tagName} tag`,
          values: {
            connectionsLabel,
            tagName: tag.name
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 11
        }
      }, columnText) : columnText;
    }
  }, ...(actions.length ? [{
    name: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.actions', {
      defaultMessage: 'Actions'
    }),
    width: '100px',
    actions
  }] : [])];
  const testSubjectState = !loading ? 'table-is-ready' : 'table-is-loading';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": `tagsManagementTable ${testSubjectState}`,
    childrenBetween: actionBar,
    loading: loading,
    itemId: 'id',
    columns: columns,
    items: tags,
    pagination: tablePagination,
    sorting: sorting,
    tableCaption: _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.columns.caption', {
      defaultMessage: 'Tags'
    }),
    rowHeader: "name",
    selection: allowSelection ? {
      selected: selectedTags,
      onSelectionChange,
      selectable: tag => !tag.managed,
      selectableMessage: selectable => selectable ? '' : _i18n.i18n.translate('xpack.savedObjectsTagging.management.table.managedMessage', {
        defaultMessage: 'This tag is managed by Elastic and cannot be deleted or assigned to objects.'
      })
    } : undefined,
    search: {
      defaultQuery: initialQuery,
      onChange: ({
        query
      }) => {
        onQueryChange(query || undefined);
      },
      box: {
        'data-test-subj': 'tagsManagementSearchBar',
        incremental: true,
        schema: {
          fields: {
            name: {
              type: 'string'
            },
            description: {
              type: 'string'
            }
          }
        }
      }
    },
    rowProps: item => ({
      'data-test-subj': 'tagsTableRow'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  });
};
exports.TagTable = TagTable;