"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromoItem = exports.CloudServerlessPromo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/cloud_serverless_promo/cloud_serverless_promo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CloudServerlessPromo = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(PromoItem, {
    promoItem: "hosted",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(PromoItem, {
    promoItem: "serverless",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  })));
};
exports.CloudServerlessPromo = CloudServerlessPromo;
const PROMO_ITEMS = {
  serverless: {
    logoPath: assetBasePath => `${assetBasePath}/search_serverless_promo_logo.svg`,
    logoAltText: _i18n.i18n.translate('xpack.searchHomepage.cloudServerlessPromo.serverlessLogoAltText', {
      defaultMessage: 'Elasticsearch Serverless logo'
    }),
    promoTitle: _i18n.i18n.translate('xpack.searchHomepage.cloudServerlessPromo.serverlessTitle', {
      defaultMessage: 'Elasticsearch Serverless'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.cloudServerlessPromo.serverlessDescription', {
      defaultMessage: 'A fully managed service providing the easiest way to start and scale. With Serverless, Elastic handles all the behind-the-scenes operations like version upgrades, sharding, and scaling.'
    }),
    externalLink: 'https://www.elastic.co/cloud/serverless'
  },
  hosted: {
    logoPath: assetBasePath => `${assetBasePath}/search_hosted_promo_logo.svg`,
    logoAltText: _i18n.i18n.translate('xpack.searchHomepage.cloudServerlessPromo.hostedLogoAltText', {
      defaultMessage: 'Elasticsearch Cloud Hosted logo'
    }),
    promoTitle: _i18n.i18n.translate('xpack.searchHomepage.cloudServerlessPromo.hostedTitle', {
      defaultMessage: 'Elasticsearch Cloud Hosted'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.cloudServerlessPromo.hostedDescription', {
      defaultMessage: 'Spin up, scale, upgrade, and delete your Elastic Stack products on the cloud provider and regions of your choice without having to manage each one separately. In an Elasatic Cloud Hosted deployment, everything works together.'
    }),
    externalLink: 'https://www.elastic.co/cloud'
  }
};
const PromoItem = ({
  promoItem
}) => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const logoStyle = (0, _react2.css)({
    'min-width': euiTheme.size.xxxxl,
    'min-height': euiTheme.size.xxxxl,
    width: euiTheme.size.xxxxl,
    height: euiTheme.size.xxxxl
  });
  const logoContainerStyle = (0, _react2.css)({
    borderRadius: euiTheme.border.radius.medium,
    padding: euiTheme.size.base,
    backgroundColor: euiTheme.colors.backgroundBaseSubdued,
    width: `${euiTheme.base * 6}px`,
    height: `${euiTheme.base * 6}px`,
    justifyContent: 'center',
    alignItems: 'center'
  });
  const {
    logoPath,
    logoAltText,
    promoTitle,
    description,
    externalLink
  } = PROMO_ITEMS[promoItem];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: logoContainerStyle,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "xs",
    src: logoPath(assetBasePath),
    alt: logoAltText,
    css: logoStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, promoTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `searchHomepagePromoItemExternalLink-${promoItem}`,
    external: true,
    href: externalLink,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.cloudServerlessPromo.serverlessLinkText', {
    defaultMessage: 'Sign up for Elastic Cloud'
  }))))));
};
exports.PromoItem = PromoItem;