"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexCodeView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _tryInConsole = require("@kbn/try-in-console");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _i18n = require("@kbn/i18n");
var _code_examples = require("../../code_examples");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _use_kibana = require("../../hooks/use_kibana");
var _use_elasticsearch_url = require("../../hooks/use_elasticsearch_url");
var _api_key_callout = require("./api_key_callout");
var _code_sample = require("./code_sample");
var _language_selector = require("./language_selector");
var _guide_selector = require("./guide_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_indices/public/components/shared/create_index_code_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateIndexCodeView = ({
  analyticsEvents,
  canCreateApiKey,
  changeCodingLanguage,
  changeWorkflowId,
  selectedWorkflow,
  indexName,
  selectedLanguage,
  selectedCodeExamples
}) => {
  const {
    application,
    share,
    cloud,
    console: consolePlugin
  } = (0, _use_kibana.useKibana)().services;
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const elasticsearchUrl = (0, _use_elasticsearch_url.useElasticsearchUrl)();
  const {
    apiKey
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const codeParams = (0, _react.useMemo)(() => {
    var _cloud$isServerlessEn;
    return {
      indexName: indexName || undefined,
      elasticsearchURL: elasticsearchUrl,
      apiKey: apiKey || undefined,
      isServerless: (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : undefined
    };
  }, [indexName, elasticsearchUrl, apiKey, cloud]);
  const selectedCodeExample = (0, _react.useMemo)(() => {
    return selectedCodeExamples[selectedLanguage];
  }, [selectedLanguage, selectedCodeExamples]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "createIndexCodeView",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, canCreateApiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_api_key_callout.APIKeyCallout, {
    apiKey: apiKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchIndices.guideSelectors.selectGuideTitle', {
    defaultMessage: 'Select a workflow guide'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_guide_selector.GuideSelector, {
    selectedWorkflowId: (selectedWorkflow === null || selectedWorkflow === void 0 ? void 0 : selectedWorkflow.id) || 'default',
    onChange: changeWorkflowId,
    showTour: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '150px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_language_selector.LanguageSelector, {
    options: _code_examples.LanguageOptions,
    selectedLanguage: selectedLanguage,
    onSelectLanguage: changeCodingLanguage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    request: selectedCodeExamples.sense.createIndex(codeParams),
    application: application,
    sharePlugin: share,
    consolePlugin: consolePlugin,
    telemetryId: `${selectedLanguage}_create_index`,
    onClick: () => {
      usageTracker.click([analyticsEvents.runInConsole, `${analyticsEvents.runInConsole}_${selectedLanguage}`]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }))), selectedCodeExample.installCommand && /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    title: selectedCodeExamples.installTitle,
    description: selectedCodeExamples.installDescription,
    language: "shell",
    code: selectedCodeExample.installCommand,
    onCodeCopyClick: () => {
      usageTracker.click([analyticsEvents.installCommands, `${analyticsEvents.installCommands}_${selectedLanguage}`]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "createIndex",
    title: selectedCodeExamples.createIndexTitle,
    description: selectedCodeExamples.createIndexDescription,
    language: _code_examples.Languages[selectedLanguage].codeBlockLanguage,
    code: selectedCodeExample.createIndex(codeParams),
    onCodeCopyClick: () => {
      usageTracker.click([analyticsEvents.createIndex, `${analyticsEvents.createIndex}_${selectedLanguage}`, `${analyticsEvents.createIndex}_${selectedLanguage}_${selectedCodeExamples.exampleType}`]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }));
};
exports.CreateIndexCodeView = CreateIndexCodeView;