"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeletePlaygroundModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _errors = require("../../../common/errors");
var _use_kibana = require("../../hooks/use_kibana");
var _use_delete_saved_playground = require("../../hooks/use_delete_saved_playground");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/delete_playground_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeletePlaygroundModal = ({
  playgroundId,
  playgroundName,
  onClose,
  onDeleteSuccess
}) => {
  const {
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const {
    deleteSavedPlayground,
    isLoading
  } = (0, _use_delete_saved_playground.useDeleteSavedPlayground)();
  const onDeleteError = (0, _react.useCallback)(error => {
    onClose();
    const errorMessage = (0, _errors.getErrorMessage)(error);
    notifications.toasts.addError(error instanceof Error ? error : new Error(errorMessage), {
      title: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.deleteError.title', {
        defaultMessage: 'Error deleting playground'
      }),
      toastMessage: errorMessage
    });
  }, [notifications.toasts, onClose]);
  const onDelete = (0, _react.useCallback)(e => {
    e.preventDefault();
    deleteSavedPlayground(playgroundId, {
      onSuccess: onDeleteSuccess,
      onError: onDeleteError
    });
  }, [deleteSavedPlayground, onDeleteError, onDeleteSuccess, playgroundId]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "deletePlaygroundActionModal",
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.deletePlayground.confirmModal.modalTitle', {
      defaultMessage: 'Delete playground'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onClose,
    onConfirm: onDelete,
    isLoading: isLoading,
    buttonColor: "danger",
    cancelButtonText: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.deletePlayground.confirmModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.deletePlayground.confirmModal.confirmButtonText', {
      defaultMessage: 'Delete playground'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.deletePlayground.deleteDescription",
    defaultMessage: "You are about to delete the {playgroundName} playground",
    values: {
      playgroundName: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 33
        }
      }, playgroundName)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.deletePlayground.deleteWarningDescription",
    defaultMessage: "You can't recover a deleted playground. Make sure you have appropriate backups.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  })))));
};
exports.DeletePlaygroundModal = DeletePlaygroundModal;