"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedPlaygroundSaveButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _errors = require("../../../common/errors");
var _use_saved_playground_parameters = require("../../hooks/use_saved_playground_parameters");
var _use_update_saved_playground = require("../../hooks/use_update_saved_playground");
var _saved_playgrounds = require("../../utils/saved_playgrounds");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/saved_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedPlaygroundSaveButton = ({
  hasChanges
}) => {
  const {
    playgroundId
  } = (0, _use_saved_playground_parameters.useSavedPlaygroundParameters)();
  const {
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const {
    getValues,
    reset,
    formState: {
      errors: formErrors
    }
  } = (0, _reactHookForm.useFormContext)();
  const {
    updateSavedPlayground,
    isLoading: isSaving
  } = (0, _use_update_saved_playground.useUpdateSavedPlayground)();
  const hasErrors = (0, _saved_playgrounds.hasSavedPlaygroundFormErrors)(formErrors);
  const onSave = (0, _react.useCallback)(e => {
    e.preventDefault();
    const formData = getValues();
    updateSavedPlayground({
      playgroundId,
      playground: (0, _saved_playgrounds.buildSavedPlaygroundFromForm)(formData)
    }, {
      onSuccess: () => {
        reset(formData);
      },
      onError: error => {
        const errorMessage = (0, _errors.getErrorMessage)(error);
        notifications.toasts.addError(error instanceof Error ? error : new Error(errorMessage), {
          title: _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.updateError.title', {
            defaultMessage: 'Error updating playground'
          }),
          toastMessage: errorMessage
        });
      }
    });
  }, [playgroundId, getValues, reset, updateSavedPlayground, notifications]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "saved-playground-save-button",
    size: "s",
    iconType: "save",
    fill: true,
    isDisabled: !hasChanges || hasErrors || isSaving,
    isLoading: isSaving,
    onClick: onSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.header.saveButton.text",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }));
};
exports.SavedPlaygroundSaveButton = SavedPlaygroundSaveButton;