"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourceFields = exports.LangchainPythonExmaple = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../types");
var _prompt = require("../../../../common/prompt");
var _user_query = require("../../../utils/user_query");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/view_code/examples/py_langchain_python.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSourceFields = sourceFields => {
  let hasContentFieldsArray = false;
  const fields = {};
  for (const indexName of Object.keys(sourceFields)) {
    if (sourceFields[indexName].length > 1) {
      fields[indexName] = sourceFields[indexName];
      hasContentFieldsArray = true;
    } else {
      fields[indexName] = sourceFields[indexName][0];
    }
  }
  return {
    hasContentFieldsArray,
    sourceFields: JSON.stringify(fields, null, 4)
  };
};
exports.getSourceFields = getSourceFields;
const LangchainPythonExmaple = ({
  formValues,
  formErrors,
  clientDetails
}) => {
  const {
    esQuery,
    hasContentFieldsArray,
    indices,
    prompt,
    sourceFields
  } = (0, _react.useMemo)(() => {
    const fields = getSourceFields(formValues.source_fields);
    return {
      esQuery: (0, _utils.getESQuery)((0, _user_query.elasticsearchQueryObject)(formValues.elasticsearch_query, formValues.user_elasticsearch_query, formErrors[_types.PlaygroundFormFields.userElasticsearchQuery])),
      indices: formValues.indices.join(','),
      prompt: (0, _prompt.Prompt)(formValues.prompt, {
        context: true,
        citations: formValues.citations,
        type: 'openai'
      }),
      ...fields
    };
  }, [formValues, formErrors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "py",
    isCopyable: true,
    overflowHeight: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, `## Install the required packages
## pip install -qU elasticsearch langchain langchain-elasticsearch langchain-openai

from elasticsearch import Elasticsearch
from langchain_elasticsearch import ElasticsearchRetriever
from langchain_openai import ChatOpenAI${hasContentFieldsArray ? '\nfrom langchain_core.documents import Document' : ''}
from langchain_core.runnables import RunnablePassthrough
from langchain_core.prompts import ChatPromptTemplate
from langchain_core.output_parsers import StrOutputParser
from langchain_core.prompts import format_document
from langchain.prompts.prompt import PromptTemplate
import os
${clientDetails}

def build_query(query):
    return ${esQuery}

index_source_fields = ${sourceFields}
${hasContentFieldsArray ? `
def context_document_mapper(hit):
    content = ""
    content_fields = index_source_fields[hit["_index"]]
    for field in content_fields:
        if field in hit["_source"] and hit["_source"][field]:
            field_content = hit["_source"][field]
            content += f"{field}: {field_content}\\n"
    return Document(page_content=content, metadata=hit)\n\n` : ''}
retriever = ElasticsearchRetriever(
    index_name="${indices}",
    body_func=build_query,
    ${hasContentFieldsArray ? 'document_mapper=context_document_mapper,' : 'content_field=index_source_fields,'}
    es_client=es_client
)

model = ChatOpenAI(openai_api_key=os.environ["OPENAI_API_KEY"], model_name="gpt-3.5-turbo")

ANSWER_PROMPT = ChatPromptTemplate.from_template(
    """${prompt}"""
)

DEFAULT_DOCUMENT_PROMPT = PromptTemplate.from_template(template="{page_content}")

def _combine_documents(
    docs, document_prompt=DEFAULT_DOCUMENT_PROMPT, document_separator="\\n\\n"
):
    doc_strings = [format_document(doc, document_prompt) for doc in docs]
    return document_separator.join(doc_strings)

_context = {
    "context": retriever | _combine_documents,
    "question": RunnablePassthrough(),
}

chain = _context | ANSWER_PROMPT | model | StrOutputParser()
ans = chain.invoke("What is it you want to ask the LLM?")
print("---- Answer ----")
print(ans)`);
};
exports.LangchainPythonExmaple = LangchainPythonExmaple;