"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.accountManagementApp = exports.Providers = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _userProfileComponents = require("@kbn/user-profile-components");
var _components = require("../components");
var _breadcrumb = require("../components/breadcrumb");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/security/public/account_management/account_management_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const accountManagementApp = exports.accountManagementApp = Object.freeze({
  id: 'security_account',
  create({
    application,
    authc,
    getStartServices,
    securityApiClients
  }) {
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.security.account.breadcrumb', {
        defaultMessage: 'User settings'
      }),
      visibleIn: [],
      appRoute: '/security/account',
      async mount({
        element,
        history
      }) {
        const [[coreStart], {
          AccountManagementPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./account_management_page')))]);
        (0, _reactDom.render)(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(Providers, {
          services: coreStart,
          history: history,
          authc: authc,
          securityApiClients: securityApiClients,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 56,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(AccountManagementPage, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 15
          }
        }))), element);
        return () => (0, _reactDom.unmountComponentAtNode)(element);
      }
    });
  }
});
const Providers = ({
  services,
  history,
  authc,
  securityApiClients,
  onChange,
  children
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_components.AuthenticationProvider, {
  authc: authc,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_components.SecurityApiClientsProvider, (0, _extends2.default)({}, securityApiClients, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: history,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
  onChange: onChange,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesKibanaProvider, {
  core: services,
  security: {
    userProfiles: securityApiClients.userProfiles
  },
  toMountPoint: _reactKibanaMount.toMountPoint,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 13
  }
}, children))))));
exports.Providers = Providers;