"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewRuleSourceSchema = exports.CoverageOverviewRuleSource = exports.CoverageOverviewRuleAttributes = exports.CoverageOverviewRuleActivitySchema = exports.CoverageOverviewRuleActivity = exports.CoverageOverviewResponse = exports.CoverageOverviewRequestBody = exports.CoverageOverviewFilter = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Rule activity (status) filter, which now can filter enabled and disabled rules.
 * Later we're going to support available rules as well (prebuilt rules that are not yet installed).
 */
let CoverageOverviewRuleActivity = exports.CoverageOverviewRuleActivity = /*#__PURE__*/function (CoverageOverviewRuleActivity) {
  CoverageOverviewRuleActivity["Enabled"] = "enabled";
  CoverageOverviewRuleActivity["Disabled"] = "disabled";
  return CoverageOverviewRuleActivity;
}({});
const CoverageOverviewRuleActivitySchema = exports.CoverageOverviewRuleActivitySchema = (0, _securitysolutionIoTsTypes.enumeration)('CoverageOverviewRuleActivity', CoverageOverviewRuleActivity);

/**
 * Rule source (origin) filter representing from where the rules came from
 */
let CoverageOverviewRuleSource = exports.CoverageOverviewRuleSource = /*#__PURE__*/function (CoverageOverviewRuleSource) {
  CoverageOverviewRuleSource["Prebuilt"] = "prebuilt";
  CoverageOverviewRuleSource["Custom"] = "custom";
  return CoverageOverviewRuleSource;
}({});
const CoverageOverviewRuleSourceSchema = exports.CoverageOverviewRuleSourceSchema = (0, _securitysolutionIoTsTypes.enumeration)('CoverageOverviewRuleSource', CoverageOverviewRuleSource);
const CoverageOverviewFilter = exports.CoverageOverviewFilter = t.partial({
  /**
   * A search term to filter the response by rule name, index pattern, MITRE ATT&CK™ tactic or technique
   *
   * @example "Defense Evasion" or "TA0005"
   */
  search_term: _securitysolutionIoTsTypes.NonEmptyString,
  /**
   * An activity filter representing an array combined of CoverageOverviewRuleActivity values to include only specified rules in the response
   */
  activity: (0, _securitysolutionIoTsTypes.NonEmptyArray)(CoverageOverviewRuleActivitySchema),
  /**
   * A source filter representing an array combined of CoverageOverviewRuleSource values to include only specified rules in the response
   */
  source: (0, _securitysolutionIoTsTypes.NonEmptyArray)(CoverageOverviewRuleSourceSchema)
});
const CoverageOverviewRequestBody = exports.CoverageOverviewRequestBody = t.exact(t.partial({
  filter: CoverageOverviewFilter
}));
const CoverageOverviewRuleAttributes = exports.CoverageOverviewRuleAttributes = t.type({
  name: t.string,
  activity: CoverageOverviewRuleActivitySchema
});
const CoverageOverviewResponse = exports.CoverageOverviewResponse = t.exact(t.type({
  /**
   * Map having (tacticId, techniqueId or subtechniqueId) as the key and an array of rule ids as the value
   */
  coverage: t.record(t.string, (0, _securitysolutionIoTsTypes.NonEmptyArray)(t.string)),
  /**
   * Array of unmapped rule ids
   */
  unmapped_rule_ids: t.array(t.string),
  /**
   * Map having ruleId as the key and coverage overview rule data as the value
   */
  rules_data: t.record(t.string, CoverageOverviewRuleAttributes)
}));