"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleLastRunOutcomeToExecutionStatus = exports.ruleExecutionStatusToNumber = void 0;
var _utility_types = require("../../../../utility_types");
var _execution_status = require("./execution_status.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleExecutionStatusToNumber = status => {
  switch (status) {
    case _execution_status.RuleExecutionStatusEnum.succeeded:
      return 0;
    case _execution_status.RuleExecutionStatusEnum['going to run']:
      return 10;
    case _execution_status.RuleExecutionStatusEnum.running:
      return 15;
    case _execution_status.RuleExecutionStatusEnum['partial failure']:
      return 20;
    case _execution_status.RuleExecutionStatusEnum.failed:
      return 30;
    default:
      (0, _utility_types.assertUnreachable)(status);
      return 0;
  }
};
exports.ruleExecutionStatusToNumber = ruleExecutionStatusToNumber;
const ruleLastRunOutcomeToExecutionStatus = outcome => {
  switch (outcome) {
    case 'succeeded':
      return _execution_status.RuleExecutionStatusEnum.succeeded;
    case 'warning':
      return _execution_status.RuleExecutionStatusEnum['partial failure'];
    case 'failed':
      return _execution_status.RuleExecutionStatusEnum.failed;
    default:
      (0, _utility_types.assertUnreachable)(outcome);
      return _execution_status.RuleExecutionStatusEnum.failed;
  }
};
exports.ruleLastRunOutcomeToExecutionStatus = ruleLastRunOutcomeToExecutionStatus;