"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelectorField = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/form_fields/connector_selector_field/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConnectorSelectorField = exports.ConnectorSelectorField = /*#__PURE__*/_react.default.memo(({
  connectorId,
  field,
  onConnectorIdSelected
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true,
    "data-test-subj": "attackDiscoveryConnectorSelectorField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    fullWidth: true,
    onConnectorSelected: _fp.noop,
    onConnectorIdSelected: onConnectorIdSelected,
    selectedConnectorId: connectorId,
    explicitConnectorSelection: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }));
});
ConnectorSelectorField.displayName = 'ConnectorSelectorField';