"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentResponseActionsStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _constants = require("../../../../../../common/endpoint/service/response_actions/constants");
var _use_test_id_generator = require("../../../../../management/hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/endpoint/agents/agent_status/agent_response_action_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TOOLTIP_CONTENT_STYLES = {
  width: 150
};
const AgentResponseActionsStatus = exports.AgentResponseActionsStatus = /*#__PURE__*/(0, _react.memo)(({
  pendingActions,
  isIsolated,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    totalPending,
    actionList,
    wasReleasing,
    wasIsolating,
    hasMultipleActionTypesPending,
    hasPendingIsolate,
    hasPendingUnIsolate
  } = (0, _react.useMemo)(() => {
    var _pendingActions$isola, _pendingActions$uniso;
    const list = [];
    let actionTotal = 0;
    const pendingActionEntries = Object.entries(pendingActions);
    const actionTypesCount = pendingActionEntries.length;
    pendingActionEntries.sort().forEach(([actionName, actionCount]) => {
      var _RESPONSE_ACTION_API_;
      actionTotal += actionCount;
      list.push({
        count: actionCount,
        label: (_RESPONSE_ACTION_API_ = _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[actionName]) !== null && _RESPONSE_ACTION_API_ !== void 0 ? _RESPONSE_ACTION_API_ : actionName
      });
    });
    const pendingIsolate = (_pendingActions$isola = pendingActions.isolate) !== null && _pendingActions$isola !== void 0 ? _pendingActions$isola : 0;
    const pendingUnIsolate = (_pendingActions$uniso = pendingActions.unisolate) !== null && _pendingActions$uniso !== void 0 ? _pendingActions$uniso : 0;
    return {
      actionList: list,
      totalPending: actionTotal,
      wasReleasing: pendingIsolate === 0 && pendingUnIsolate > 0,
      wasIsolating: pendingIsolate > 0 && pendingUnIsolate === 0,
      hasMultipleActionTypesPending: actionTypesCount > 1,
      hasPendingIsolate: pendingIsolate > 0,
      hasPendingUnIsolate: pendingUnIsolate > 0
    };
  }, [pendingActions]);
  const badgeDisplayValue = (0, _react.useMemo)(() => {
    return hasPendingIsolate ? _translations.ISOLATING_LABEL : hasPendingUnIsolate ? _translations.RELEASING_LABEL : isIsolated ? _translations.ISOLATED_LABEL : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.agentStatus.actionStatus.multiplePendingActions",
      defaultMessage: "{count} {count, plural, one {action} other {actions}} pending",
      values: {
        count: totalPending
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    });
  }, [hasPendingIsolate, hasPendingUnIsolate, isIsolated, totalPending]);
  const isolatedBadge = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, _translations.ISOLATED_LABEL);
  }, [dataTestSubj]);

  // If nothing is pending
  if (totalPending === 0) {
    // and host is either releasing and or currently released, then render nothing
    if (!wasIsolating && wasReleasing || !isIsolated) {
      return null;
    }
    // else host was isolating or is isolated, then show isolation badge
    else if (!isIsolated && wasIsolating && !wasReleasing || isIsolated) {
      return isolatedBadge;
    }
  }

  // If there are different types of action pending
  //    --OR--
  // the only type of actions pending is NOT isolate/release,
  // then show a summary with tooltip
  if (hasMultipleActionTypesPending || !hasPendingIsolate && !hasPendingUnIsolate) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": dataTestSubj,
      iconType: "plus",
      iconSide: "right",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      anchorClassName: "eui-textTruncate",
      anchorProps: {
        'data-test-subj': getTestId('tooltipTrigger')
      },
      content: /*#__PURE__*/_react.default.createElement("div", {
        css: TOOLTIP_CONTENT_STYLES,
        "data-test-subj": `${dataTestSubj}-tooltipContent`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.agentStatus.actionStatus.tooltipPendingActions",
        defaultMessage: "Pending actions:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 19
        }
      })), actionList.map(({
        count,
        label
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "none",
          key: label,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 23
          }
        }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 142,
            columnNumber: 23
          }
        }, count));
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      "data-test-subj": `${dataTestSubj}-pending`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 13
      }
    }, badgeDisplayValue)));
  }

  // show pending isolation badge if a single type of isolation action has pending numbers.
  // We don't care about the count here because if there were more than 1 of the same type
  // (ex. 3 isolate... 0 release), then the action status displayed is still the same - "isolating".
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    "data-test-subj": getTestId('pending'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, badgeDisplayValue));
});
AgentResponseActionsStatus.displayName = 'AgentResponseActionsStatus';