"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulEventsViewer = void 0;
var _react = require("@emotion/react");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = require("styled-components");
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _eui = require("@elastic/eui");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _inspect = require("../inspect");
var _constants = require("../../store/inputs/constants");
var _actions = require("../../store/actions");
var _containers = require("../../../sourcerer/containers");
var _kibana = require("../../lib/kibana");
var _fields_browser = require("../../../timelines/components/fields_browser");
var _helpers = require("./helpers");
var _use_timelines_events = require("./use_timelines_events");
var _shared = require("./shared");
var _manage_query = require("../page/manage_query");
var _control_columns = require("../control_columns");
var _use_alert_bulk_actions = require("./use_alert_bulk_actions");
var _stateful_event_context = require("./stateful_event_context");
var _unit = require("../toolbar/unit");
var _selectors = require("../../store/inputs/selectors");
var _use_get_field_spec = require("../../hooks/use_get_field_spec");
var _use_experimental_features = require("../../hooks/use_experimental_features");
var _use_selected_patterns = require("../../../data_view_manager/hooks/use_selected_patterns");
var _use_browser_fields = require("../../../data_view_manager/hooks/use_browser_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/events_viewer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* TODO: (new data view picker) remove this after new picker is enabled */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SECURITY_ALERTS_CONSUMERS = [_ruleDataUtils.AlertConsumers.SIEM];
/**
 * The stateful events viewer component is the highest level component that is utilized across the security_solution pages layer where
 * timeline is used BESIDES the flyout. The flyout makes use of the `EventsViewer` component which is a subcomponent here
 * NOTE: As of writting, it is not used in the Case_View component
 */
const StatefulEventsViewerComponent = ({
  bulkActions,
  cellActionsTriggerId,
  clearSelected,
  defaultModel,
  end,
  entityType = 'events',
  indexNames,
  leadingControlColumns,
  pageFilters,
  renderCellValue,
  rowRenderers,
  setSelected,
  sourcererScope,
  start,
  tableId,
  topRightMenuOptions,
  unit = _unit.defaultUnit
}) => {
  var _experimentalDataView;
  const dispatch = (0, _reactRedux.useDispatch)();
  const theme = (0, _react2.useContext)(_styledComponents.ThemeContext);
  const tableContext = (0, _react2.useMemo)(() => ({
    tableId
  }), [tableId]);
  const selectGlobalFiltersQuerySelector = (0, _react2.useMemo)(() => (0, _selectors.globalFiltersQuerySelector)(), []);
  const selectGlobalQuerySelector = (0, _react2.useMemo)(() => (0, _selectors.globalQuerySelector)(), []);
  const filters = (0, _reactRedux.useSelector)(selectGlobalFiltersQuerySelector);
  const query = (0, _reactRedux.useSelector)(selectGlobalQuerySelector);
  const selectTableById = (0, _react2.useMemo)(() => (0, _securitysolutionDataTable.getTableByIdSelector)(), []);
  const {
    columns,
    defaultColumns,
    deletedEventIds,
    itemsPerPage,
    itemsPerPageOptions,
    showCheckboxes,
    sort,
    queryFields,
    selectAll,
    selectedEventIds,
    isSelectAllChecked,
    loadingEventIds,
    title
  } = (0, _reactRedux.useSelector)(state => {
    var _selectTableById;
    return (_selectTableById = selectTableById(state, tableId)) !== null && _selectTableById !== void 0 ? _selectTableById : defaultModel;
  });
  const inspectModalTitle = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 43
    }
  }, title), [title]);
  const {
    uiSettings,
    data
  } = (0, _kibana.useKibana)().services;
  const {
    browserFields: oldBrowserFields,
    dataViewId: oldDataViewId,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataView,
    loading: oldIsLoadingIndexPattern
  } = (0, _containers.useSourcererDataView)(sourcererScope);
  const oldGetFieldSpec = (0, _use_get_field_spec.useGetFieldSpec)(sourcererScope);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(sourcererScope);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(sourcererScope);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(sourcererScope);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const isLoadingIndexPattern = newDataViewPickerEnabled ? status !== 'ready' : oldIsLoadingIndexPattern;
  const dataViewId = newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : null : oldDataViewId;
  const selectedDataViewId = newDataViewPickerEnabled ? experimentalDataView.id : oldDataViewId;
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const runtimeMappings = (0, _react2.useMemo)(() => {
    var _ref, _ref2;
    return newDataViewPickerEnabled ? (_ref = experimentalDataView.getRuntimeMappings()) !== null && _ref !== void 0 ? _ref : {} : (_ref2 = oldSourcererDataView === null || oldSourcererDataView === void 0 ? void 0 : oldSourcererDataView.runtimeFieldMap) !== null && _ref2 !== void 0 ? _ref2 : {};
  }, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataView]);
  const experimentalGetFieldSpec = (0, _react2.useCallback)(fieldName => {
    var _experimentalDataView2, _experimentalDataView3;
    return (_experimentalDataView2 = experimentalDataView.fields) === null || _experimentalDataView2 === void 0 ? void 0 : (_experimentalDataView3 = _experimentalDataView2.getByName(fieldName)) === null || _experimentalDataView3 === void 0 ? void 0 : _experimentalDataView3.toSpec();
  }, [experimentalDataView.fields]);
  const getFieldSpec = newDataViewPickerEnabled ? experimentalGetFieldSpec : oldGetFieldSpec;
  const editorActionsRef = (0, _react2.useRef)(null);
  (0, _react2.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.createDataTable({
      columns,
      dataViewId: selectedDataViewId,
      defaultColumns,
      id: tableId,
      indexNames: indexNames !== null && indexNames !== void 0 ? indexNames : selectedPatterns,
      itemsPerPage,
      showCheckboxes,
      sort
    }));
    return () => {
      dispatch(_actions.inputsActions.deleteOneQuery({
        id: tableId,
        inputId: _constants.InputsModelId.global
      }));
      if (editorActionsRef.current) {
        // eslint-disable-next-line react-hooks/exhaustive-deps
        editorActionsRef.current.closeEditor();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const globalFilters = (0, _react2.useMemo)(() => [...filters, ...(pageFilters !== null && pageFilters !== void 0 ? pageFilters : [])], [filters, pageFilters]);
  const setQuery = (0, _react2.useCallback)(({
    id,
    inspect,
    loading,
    refetch
  }) => dispatch(_actions.inputsActions.setQuery({
    id,
    inputId: _constants.InputsModelId.global,
    inspect,
    loading,
    refetch
  })), [dispatch]);
  const fieldBrowserOptions = (0, _fields_browser.useFieldBrowserOptions)({
    sourcererScope,
    editorActionsRef,
    upsertColumn: (0, _react2.useCallback)((column, index) => dispatch(_securitysolutionDataTable.dataTableActions.upsertColumn({
      column,
      id: tableId,
      index
    })), [dispatch, tableId]),
    removeColumn: (0, _react2.useCallback)(columnId => dispatch(_securitysolutionDataTable.dataTableActions.removeColumn({
      columnId,
      id: tableId
    })), [dispatch, tableId])
  });
  const columnHeaders = (0, _lodash.isEmpty)(columns) ? _securitysolutionDataTable.defaultHeaders : columns;
  const esQueryConfig = (0, _common.getEsQueryConfig)(uiSettings);
  const filterQuery = (0, _react2.useMemo)(() => (0, _helpers.getCombinedFilterQuery)({
    config: esQueryConfig,
    browserFields,
    dataProviders: [],
    filters: globalFilters,
    from: start,
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    kqlMode: 'filter',
    kqlQuery: query,
    to: end
  }), [esQueryConfig, browserFields, globalFilters, start, oldSourcererDataView, experimentalDataView, query, end]);
  const canQueryTimeline = (0, _react2.useMemo)(() => filterQuery != null && isLoadingIndexPattern != null && !isLoadingIndexPattern && !(0, _lodash.isEmpty)(start) && !(0, _lodash.isEmpty)(end), [isLoadingIndexPattern, filterQuery, start, end]);
  const fields = (0, _react2.useMemo)(() => [...columnHeaders.map(c => c.id), ...(queryFields !== null && queryFields !== void 0 ? queryFields : [])], [columnHeaders, queryFields]);
  const sortField = (0, _react2.useMemo)(() => sort.map(({
    columnId,
    columnType,
    esTypes,
    sortDirection
  }) => ({
    field: columnId,
    type: columnType,
    direction: sortDirection,
    esTypes: esTypes !== null && esTypes !== void 0 ? esTypes : []
  })), [sort]);
  const [loading, {
    events,
    loadPage,
    pageInfo,
    refetch,
    totalCount = 0,
    inspect
  }] = (0, _use_timelines_events.useTimelineEvents)({
    // We rely on entityType to determine Events vs Alerts
    alertConsumers: SECURITY_ALERTS_CONSUMERS,
    data,
    dataViewId,
    endDate: end,
    entityType,
    fields,
    filterQuery,
    id: tableId,
    indexNames: indexNames !== null && indexNames !== void 0 ? indexNames : selectedPatterns,
    limit: itemsPerPage,
    runtimeMappings,
    skip: !canQueryTimeline,
    sort: sortField,
    startDate: start,
    filterStatus: undefined
  });
  (0, _react2.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.updateIsLoading({
      id: tableId,
      isLoading: loading
    }));
  }, [dispatch, tableId, loading]);
  const deleteQuery = (0, _react2.useCallback)(({
    id
  }) => dispatch(_actions.inputsActions.deleteOneQuery({
    inputId: _constants.InputsModelId.global,
    id
  })), [dispatch]);
  (0, _manage_query.useQueryInspector)({
    queryId: tableId,
    loading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  const totalCountMinusDeleted = (0, _react2.useMemo)(() => totalCount > 0 ? totalCount - deletedEventIds.length : 0, [deletedEventIds.length, totalCount]);
  const hasAlerts = totalCountMinusDeleted > 0;

  // Only show the table-spanning loading indicator when the query is loading and we
  // don't have data (e.g. for the initial fetch).
  // Subsequent fetches (e.g. for pagination) will show a small loading indicator on
  // top of the table and the table will display the current page until the next page
  // is fetched. This prevents a flicker when paginating.
  const showFullLoading = loading && !hasAlerts;
  const nonDeletedEvents = (0, _react2.useMemo)(() => events.filter(e => !deletedEventIds.includes(e._id)), [deletedEventIds, events]);
  (0, _react2.useEffect)(() => {
    setQuery({
      id: tableId,
      inspect,
      loading,
      refetch
    });
  }, [inspect, loading, refetch, setQuery, tableId]);

  // Clear checkbox selection when new events are fetched
  (0, _react2.useEffect)(() => {
    dispatch(_securitysolutionDataTable.dataTableActions.clearSelected({
      id: tableId
    }));
    dispatch(_securitysolutionDataTable.dataTableActions.setDataTableSelectAll({
      id: tableId,
      selectAll: false
    }));
  }, [nonDeletedEvents, dispatch, tableId]);
  const onChangeItemsPerPage = (0, _react2.useCallback)(itemsChangedPerPage => {
    dispatch(_securitysolutionDataTable.dataTableActions.updateItemsPerPage({
      id: tableId,
      itemsPerPage: itemsChangedPerPage
    }));
  }, [tableId, dispatch]);
  const onChangePage = (0, _react2.useCallback)(page => {
    loadPage(page);
  }, [loadPage]);
  const setEventsLoading = (0, _react2.useCallback)(({
    eventIds,
    isLoading
  }) => {
    dispatch(_securitysolutionDataTable.dataTableActions.setEventsLoading({
      id: tableId,
      eventIds,
      isLoading
    }));
  }, [dispatch, tableId]);
  const setEventsDeleted = (0, _react2.useCallback)(({
    eventIds,
    isDeleted
  }) => {
    dispatch(_securitysolutionDataTable.dataTableActions.setEventsDeleted({
      id: tableId,
      eventIds,
      isDeleted
    }));
  }, [dispatch, tableId]);
  const selectedCount = (0, _react2.useMemo)(() => Object.keys(selectedEventIds).length, [selectedEventIds]);
  const onRowSelected = (0, _react2.useCallback)(({
    eventIds,
    isSelected
  }) => {
    setSelected({
      id: tableId,
      eventIds: (0, _securitysolutionDataTable.getEventIdToDataMapping)(nonDeletedEvents, eventIds, queryFields, true),
      isSelected,
      isSelectAllChecked: isSelected && selectedCount + 1 === nonDeletedEvents.length
    });
  }, [setSelected, tableId, nonDeletedEvents, queryFields, selectedCount]);
  const onSelectPage = (0, _react2.useCallback)(({
    isSelected
  }) => isSelected ? setSelected({
    id: tableId,
    eventIds: (0, _securitysolutionDataTable.getEventIdToDataMapping)(nonDeletedEvents, nonDeletedEvents.map(event => event._id), queryFields, true),
    isSelected,
    isSelectAllChecked: isSelected
  }) : clearSelected({
    id: tableId
  }), [setSelected, tableId, nonDeletedEvents, queryFields, clearSelected]);

  // Sync to selectAll so parent components can select all events
  (0, _react2.useEffect)(() => {
    if (selectAll && !isSelectAllChecked) {
      onSelectPage({
        isSelected: true
      });
    }
  }, [isSelectAllChecked, onSelectPage, selectAll]);
  const [transformedLeadingControlColumns] = (0, _react2.useMemo)(() => {
    return [showCheckboxes ? [_control_columns.checkBoxControlColumn, ...leadingControlColumns] : leadingControlColumns].map(controlColumns => (0, _control_columns.transformControlColumns)({
      columnHeaders,
      controlColumns,
      data: nonDeletedEvents,
      fieldBrowserOptions,
      loadingEventIds,
      onRowSelected,
      onRuleChange: undefined,
      selectedEventIds,
      showCheckboxes,
      tabType: 'query',
      timelineId: tableId,
      isSelectAllChecked,
      sort,
      browserFields,
      onSelectPage,
      theme,
      setEventsLoading,
      setEventsDeleted,
      pageSize: itemsPerPage
    }));
  }, [showCheckboxes, leadingControlColumns, columnHeaders, nonDeletedEvents, fieldBrowserOptions, loadingEventIds, onRowSelected, selectedEventIds, tableId, isSelectAllChecked, sort, browserFields, onSelectPage, theme, setEventsLoading, setEventsDeleted, itemsPerPage]);
  const alertBulkActions = (0, _use_alert_bulk_actions.useAlertBulkActions)({
    tableId,
    data: nonDeletedEvents,
    totalItems: totalCountMinusDeleted,
    hasAlertsCrud: true,
    showCheckboxes,
    filterStatus: undefined,
    filterQuery,
    bulkActions,
    selectedCount
  });

  // Store context in state rather than creating object in provider value={} to prevent re-renders caused by a new object being created
  const [activeStatefulEventContext] = (0, _react2.useState)({
    timelineID: tableId,
    tabType: 'query',
    enableHostDetailsFlyout: true,
    enableIpDetailsFlyout: true
  });
  const unitCountText = (0, _react2.useMemo)(() => `${totalCountMinusDeleted.toLocaleString()} ${unit(totalCountMinusDeleted)}`, [totalCountMinusDeleted, unit]);
  const pagination = (0, _react2.useMemo)(() => ({
    pageIndex: pageInfo.activePage,
    pageSize: itemsPerPage,
    pageSizeOptions: itemsPerPageOptions,
    onChangeItemsPerPage,
    onChangePage
  }), [itemsPerPage, itemsPerPageOptions, onChangeItemsPerPage, onChangePage, pageInfo.activePage]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "events-viewer-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 515,
      columnNumber: 5
    }
  }, showFullLoading && /*#__PURE__*/_react2.default.createElement(_shared.TableLoading, {
    height: "short",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 27
    }
  }), canQueryTimeline && /*#__PURE__*/_react2.default.createElement(_shared.TableContext.Provider, {
    value: tableContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 519,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    "data-timeline-id": tableId,
    "data-test-subj": `events-container-loading-${loading}`,
    css: (0, _react.css)`
              position: relative;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 520,
      columnNumber: 11
    }
  }, !loading && /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                  position: absolute;
                  top: ${theme.eui.euiSizeXS};
                  z-index: ${theme.eui.euiZLevel1 - 3};
                  right: ${nonDeletedEvents.length > 0 ? '72px' : theme.eui.euiSizeXS};
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "events-viewer-updated",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 536,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 537,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_inspect.InspectButton, {
    title: inspectModalTitle,
    queryId: tableId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 21
    }
  })), topRightMenuOptions && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 541,
      columnNumber: 21
    }
  }, topRightMenuOptions))), !hasAlerts && !loading && /*#__PURE__*/_react2.default.createElement(_shared.EmptyTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 547,
      columnNumber: 40
    }
  }), hasAlerts && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
                  display: flex;
                  overflow: auto;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 550,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_stateful_event_context.StatefulEventContext.Provider, {
    value: activeStatefulEventContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_securitysolutionDataTable.DataTableComponent, {
    additionalControls: alertBulkActions,
    browserFields: browserFields,
    bulkActions: bulkActions,
    data: nonDeletedEvents,
    fieldBrowserOptions: fieldBrowserOptions,
    id: tableId,
    leadingControlColumns: transformedLeadingControlColumns,
    loadPage: loadPage
    // TODO: migrate away from deprecated type
    ,
    renderCellValue: renderCellValue
    // TODO: migrate away from deprecated type
    ,
    rowRenderers: rowRenderers,
    unitCountText: unitCountText,
    pagination: pagination,
    totalItems: totalCountMinusDeleted,
    getFieldSpec: getFieldSpec,
    cellActionsTriggerId: cellActionsTriggerId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 557,
      columnNumber: 19
    }
  }))))));
};
const mapDispatchToProps = {
  clearSelected: _securitysolutionDataTable.dataTableActions.clearSelected,
  setSelected: _securitysolutionDataTable.dataTableActions.setSelected
};
const connector = (0, _reactRedux.connect)(undefined, mapDispatchToProps);
const StatefulEventsViewer = exports.StatefulEventsViewer = connector(StatefulEventsViewerComponent);