"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlHostConditionalContainer = void 0;
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-utils-plugin/public");
var _add_entities_to_kql = require("./add_entities_to_kql");
var _replace_kql_parts = require("./replace_kql_parts");
var _entity_helpers = require("./entity_helpers");
var _model = require("../../../../explore/hosts/store/model");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/conditional_links/ml_host_conditional_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MlHostConditionalContainer = exports.MlHostConditionalContainer = /*#__PURE__*/_react.default.memo(() => {
  const {
    path
  } = (0, _reactRouterDom.useRouteMatch)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    exact: true,
    path: path,
    render: ({
      location
    }) => {
      const queryStringDecoded = (0, _queryString.parse)(location.search.substring(1), {
        sort: false
      });
      if (queryStringDecoded.query != null) {
        queryStringDecoded.query = (0, _replace_kql_parts.replaceKQLParts)(queryStringDecoded.query);
      }
      const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
        sort: false,
        encode: false
      });
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: `${_constants.HOSTS_PATH}?${reEncoded}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 18
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${path}/:hostName`,
    render: ({
      location,
      match: {
        params: {
          hostName
        }
      }
    }) => {
      const queryStringDecoded = (0, _queryString.parse)(location.search.substring(1), {
        sort: false
      });
      if (queryStringDecoded.query != null) {
        queryStringDecoded.query = (0, _replace_kql_parts.replaceKQLParts)(queryStringDecoded.query);
      }
      if ((0, _entity_helpers.emptyEntity)(hostName)) {
        const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
          sort: false,
          encode: false
        });
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: `${_constants.HOSTS_PATH}/${_model.HostsTableType.anomalies}?${reEncoded}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 20
          }
        });
      } else if ((0, _entity_helpers.multipleEntities)(hostName)) {
        const hosts = (0, _entity_helpers.getMultipleEntities)(hostName);
        queryStringDecoded.query = (0, _add_entities_to_kql.addEntitiesToKql)(['host.name'], hosts, queryStringDecoded.query || '');
        const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
          sort: false,
          encode: false
        });
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: `${_constants.HOSTS_PATH}/${_model.HostsTableType.anomalies}?${reEncoded}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 20
          }
        });
      } else {
        const reEncoded = (0, _queryString.stringify)(_public.url.encodeQuery(queryStringDecoded), {
          sort: false,
          encode: false
        });
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: `${_constants.HOSTS_PATH}/name/${hostName}/${_model.HostsTableType.anomalies}?${reEncoded}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 15
          }
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.HOSTS_PATH}/ml-hosts/`,
    render: ({
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      from: `${_constants.HOSTS_PATH}/ml-hosts/`,
      to: `${_constants.HOSTS_PATH}/ml-hosts${search}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
});
MlHostConditionalContainer.displayName = 'MlHostConditionalContainer';