"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsFeed = void 0;
var _react = _interopRequireDefault(require("react"));
var _loading_placeholders = require("../../../overview/components/loading_placeholders");
var _translations = require("../../../overview/pages/translations");
var _sidebar_header = require("../sidebar_header");
var _no_news = require("./no_news");
var _post = require("./post");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/news_feed/news_feed.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SHOW_PLACEHOLDERS = 5;
const LINES_PER_LOADING_PLACEHOLDER = 4;
const NewsFeedComponent = ({
  news
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: _translations.NEWS_FEED_TITLE,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 5
  }
}), news == null ? /*#__PURE__*/_react.default.createElement(_loading_placeholders.LoadingPlaceholders, {
  lines: LINES_PER_LOADING_PLACEHOLDER,
  placeholders: SHOW_PLACEHOLDERS,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 7
  }
}) : news.length === 0 ? /*#__PURE__*/_react.default.createElement(_no_news.NoNews, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 7
  }
}) : news.map(n => /*#__PURE__*/_react.default.createElement(_post.Post, {
  key: n.hash,
  newsItem: n,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 33
  }
})));
NewsFeedComponent.displayName = 'NewsFeedComponent';
const NewsFeed = exports.NewsFeed = /*#__PURE__*/_react.default.memo(NewsFeedComponent);