"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResolveConflict = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _rison = require("@kbn/rison");
var _use_selector = require("./use_selector");
var _timeline = require("../../../common/types/timeline");
var _store = require("../../timelines/store");
var _defaults = require("../../timelines/store/defaults");
var _kibana = require("../lib/kibana");
var _use_url_state = require("./use_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/common/hooks/use_resolve_conflict.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Potentially why the markdown component needs a click handler as well for timeline?
 * see: x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/plugins/timeline/processor.tsx
 */
const useResolveConflict = () => {
  const {
    search,
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    spaces
  } = (0, _kibana.useKibana)().services;
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    resolveTimelineConfig,
    savedObjectId,
    show,
    activeTab
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, _timeline.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
  });
  const getLegacyUrlConflictCallout = (0, _react.useCallback)(() => {
    var _searchQuery$get, _ref, _resolveTimelineConfi;
    // This function returns a callout component *if* we have encountered a "legacy URL conflict" scenario

    const searchQuery = new URLSearchParams(search);
    const timelineRison = (_searchQuery$get = searchQuery.get(_use_url_state.URL_PARAM_KEY.timeline)) !== null && _searchQuery$get !== void 0 ? _searchQuery$get : undefined;
    // Try to get state on URL, but default to what's in Redux in case of decodeRisonFailure
    const currentTimelineState = {
      id: savedObjectId !== null && savedObjectId !== void 0 ? savedObjectId : '',
      isOpen: !!show,
      activeTab
    };
    const timelineSearch = (_ref = (0, _rison.safeDecode)(timelineRison !== null && timelineRison !== void 0 ? timelineRison : '')) !== null && _ref !== void 0 ? _ref : currentTimelineState;

    // We have resolved to one object, but another object has a legacy URL alias associated with this ID/page. We should display a
    // callout with a warning for the user, and provide a way for them to navigate to the other object.
    const currentObjectId = timelineSearch === null || timelineSearch === void 0 ? void 0 : timelineSearch.id;
    if (!spaces || (resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.outcome) !== 'conflict' || (resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.alias_target_id) == null || currentObjectId == null) {
      return null;
    }
    const newSavedObjectId = (_resolveTimelineConfi = resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.alias_target_id) !== null && _resolveTimelineConfi !== void 0 ? _resolveTimelineConfi : ''; // This is always defined if outcome === 'conflict'

    const newTimelineSearch = {
      ...timelineSearch,
      id: newSavedObjectId
    };
    const newTimelineRison = (0, _rison.encode)(newTimelineSearch);
    searchQuery.set(_use_url_state.URL_PARAM_KEY.timeline, newTimelineRison);
    const newPath = `${pathname}?${searchQuery.toString()}${window.location.hash}`;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, spaces.ui.components.getLegacyUrlConflict({
      objectNoun: _use_url_state.URL_PARAM_KEY.timeline,
      currentObjectId,
      otherObjectId: newSavedObjectId,
      otherObjectPath: newPath
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }));
  }, [activeTab, pathname, resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.alias_target_id, resolveTimelineConfig === null || resolveTimelineConfig === void 0 ? void 0 : resolveTimelineConfig.outcome, savedObjectId, search, show, spaces]);
  return (0, _react.useMemo)(() => getLegacyUrlConflictCallout(), [getLegacyUrlConflictCallout]);
};
exports.useResolveConflict = useResolveConflict;