"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHttp = exports.useDateFormat = exports.useCurrentUser = exports.useCapabilities = exports.useBasePath = exports.useAppUrl = exports.convertToCamelCase = exports.convertArrayToCamelCase = void 0;
Object.defineProperty(exports, "useNavigateTo", {
  enumerable: true,
  get: function () {
    return _securitySolutionNavigation.useNavigateTo;
  }
});
Object.defineProperty(exports, "useNavigation", {
  enumerable: true,
  get: function () {
    return _securitySolutionNavigation.useNavigation;
  }
});
exports.useToasts = exports.useTimeZone = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../../../../common/constants");
var _toasters = require("../../components/toasters");
var _kibana_react = require("./kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDateFormat = () => (0, _kibana_react.useUiSetting)(_constants.DEFAULT_DATE_FORMAT);
exports.useDateFormat = useDateFormat;
const useTimeZone = () => {
  const timeZone = (0, _kibana_react.useUiSetting)(_constants.DEFAULT_DATE_FORMAT_TZ);
  return timeZone === 'Browser' ? _momentTimezone.default.tz.guess() : timeZone;
};
exports.useTimeZone = useTimeZone;
const useBasePath = () => (0, _kibana_react.useKibana)().services.http.basePath.get();
exports.useBasePath = useBasePath;
const useToasts = () => (0, _kibana_react.useKibana)().services.notifications.toasts;
exports.useToasts = useToasts;
const useHttp = () => (0, _kibana_react.useKibana)().services.http;
exports.useHttp = useHttp;
const convertArrayToCamelCase = arrayOfSnakes => arrayOfSnakes.reduce((acc, value) => {
  if ((0, _lodash.isArray)(value)) {
    return [...acc, convertArrayToCamelCase(value)];
  } else if ((0, _lodash.isObject)(value)) {
    return [...acc, convertToCamelCase(value)];
  } else {
    return [...acc, value];
  }
}, []);
exports.convertArrayToCamelCase = convertArrayToCamelCase;
const convertToCamelCase = snakeCase => Object.entries(snakeCase).reduce((acc, [key, value]) => {
  if ((0, _lodash.isArray)(value)) {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), convertArrayToCamelCase(value));
  } else if ((0, _lodash.isObject)(value)) {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), convertToCamelCase(value));
  } else {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), value);
  }
  return acc;
}, {});
exports.convertToCamelCase = convertToCamelCase;
const useCurrentUser = () => {
  const isMounted = (0, _react.useRef)(false);
  const [user, setUser] = (0, _react.useState)(null);
  const [, dispatchToaster] = (0, _toasters.useStateToaster)();
  const {
    security
  } = (0, _kibana_react.useKibana)().services;
  const fetchUser = (0, _react.useCallback)(() => {
    let didCancel = false;
    const fetchData = async () => {
      try {
        if (security != null) {
          const response = await security.authc.getCurrentUser();
          if (!isMounted.current) return;
          if (!didCancel) {
            setUser(convertToCamelCase(response));
          }
        } else {
          setUser({
            username: _i18n.i18n.translate('xpack.securitySolution.getCurrentUser.unknownUser', {
              defaultMessage: 'Unknown'
            }),
            email: '',
            fullName: '',
            roles: [],
            enabled: false,
            authenticationRealm: {
              name: '',
              type: ''
            },
            lookupRealm: {
              name: '',
              type: ''
            },
            authenticationProvider: ''
          });
        }
      } catch (error) {
        if (!didCancel) {
          (0, _toasters.errorToToaster)({
            title: _i18n.i18n.translate('xpack.securitySolution.getCurrentUser.Error', {
              defaultMessage: 'Error getting user'
            }),
            error: error.body && error.body.message ? new Error(error.body.message) : error,
            dispatchToaster
          });
          setUser(null);
        }
      }
    };
    fetchData();
    return () => {
      didCancel = true;
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [security]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    fetchUser();
    return () => {
      isMounted.current = false;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return user;
};
exports.useCurrentUser = useCurrentUser;
const useAppUrl = exports.useAppUrl = _securitySolutionNavigation.useGetAppUrl;
// Get the type for any feature capability

/**
 * Returns the feature capability when the `featureId` parameter is defined,
 * or the entire kibana `Capabilities` object when the parameter is omitted.
 */
const useCapabilities = featureId => {
  const {
    capabilities
  } = (0, _kibana_react.useKibana)().services.application;
  return featureId ? capabilities[featureId] : capabilities;
};
exports.useCapabilities = useCapabilities;