"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildRelatedIntegrationsDescription = exports.RelatedIntegrationsDescription = exports.IntegrationDescriptionComponent = exports.IntegrationDescription = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_related_integrations = require("../use_related_integrations");
var _integration_link = require("./integration_link");
var _integration_status_badge = require("./integration_status_badge");
var _integration_version_mismatch_icon = require("./integration_version_mismatch_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/common/components/related_integrations/integrations_description/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Wrapper = _styledComponents.default.div`
  overflow: hidden;
`;
const IntegrationDescriptionComponent = ({
  integration,
  dataTestSubj = 'integrationDescription'
}) => {
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    "data-test-subj": `${dataTestSubj}-${integration.packageName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_integration_status_badge.IntegrationStatusBadge, {
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_integration_version_mismatch_icon.IntegrationVersionMismatchIcon, {
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
};
exports.IntegrationDescriptionComponent = IntegrationDescriptionComponent;
const IntegrationDescription = exports.IntegrationDescription = /*#__PURE__*/_react.default.memo(IntegrationDescriptionComponent);
const RelatedIntegrationsDescription = ({
  relatedIntegrations,
  dataTestSubj = 'relatedIntegrationsDescription'
}) => {
  const {
    integrations
  } = (0, _use_related_integrations.useRelatedIntegrations)(relatedIntegrations);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, integrations.map((integration, index) => /*#__PURE__*/_react.default.createElement(IntegrationDescription, {
    key: `${integration.packageName}-${index}`,
    integration: integration,
    dataTestSubj: dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })));
};
exports.RelatedIntegrationsDescription = RelatedIntegrationsDescription;
const buildRelatedIntegrationsDescription = (label, relatedIntegrations) => {
  if (relatedIntegrations == null || relatedIntegrations.length === 0) {
    return [];
  }
  return [{
    title: label,
    description: /*#__PURE__*/_react.default.createElement(RelatedIntegrationsDescription, {
      relatedIntegrations: relatedIntegrations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 20
      }
    })
  }];
};
exports.buildRelatedIntegrationsDescription = buildRelatedIntegrationsDescription;