"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepActionsDefaultValue = exports.StepRuleActionsReadOnly = exports.StepRuleActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _rule_actions_field = require("../../../../common/components/rule_actions_field");
var _response_actions_form = require("../../../rule_response_actions/response_actions_form");
var _shared_imports = require("../../../../shared_imports");
var _step_content_wrapper = require("../step_content_wrapper");
var _kibana = require("../../../../common/lib/kibana");
var _use_fetch_connectors_query = require("../../../rule_management/api/hooks/use_fetch_connectors_query");
var _use_fetch_connector_types_query = require("../../../rule_management/api/hooks/use_fetch_connector_types_query");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_snooze_section = require("./rule_snooze_section");
var _notification_action = require("./notification_action");
var _response_action = require("./response_action");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/step_rule_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const stepActionsDefaultValue = exports.stepActionsDefaultValue = {
  enabled: true,
  actions: [],
  responseActions: [],
  kibanaSiemAppUrl: ''
};
const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const DisplayActionsHeader = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions",
    id: "xpack.securitySolution.detectionEngine.rule.editRule.actionSectionsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};
const StepRuleActionsComponent = ({
  ruleId,
  ruleTypeId,
  isUpdateView = false,
  actionMessageParams,
  summaryActionMessageParams,
  form,
  ruleInterval
}) => {
  const {
    services: {
      application
    }
  } = (0, _kibana.useKibana)();
  const displayActionsOptions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "actions",
    component: _rule_actions_field.RuleActionsField,
    componentProps: {
      messageVariables: actionMessageParams,
      summaryMessageVariables: summaryActionMessageParams,
      ruleTypeId,
      minimumThrottleInterval: (0, _utils.transformRuleInterval)(ruleInterval)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  })), [actionMessageParams, ruleTypeId, summaryActionMessageParams, ruleInterval]);
  const displayResponseActionsOptions = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
      path: "responseActions",
      initialNumberOfItems: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }, _response_actions_form.ResponseActionsForm);
  }, []);
  // only display the actions dropdown if the user has "read" privileges for actions
  const displayActionsDropDown = (0, _react.useMemo)(() => {
    return application.capabilities.actions.show ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DisplayActionsHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }), ruleId && /*#__PURE__*/_react.default.createElement(_rule_snooze_section.RuleSnoozeSection, {
      ruleId: ruleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 20
      }
    }), displayActionsOptions, displayResponseActionsOptions, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "kibanaSiemAppUrl",
      component: GhostFormField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "enabled",
      component: GhostFormField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, i18n.NO_ACTIONS_READ_PERMISSIONS));
  }, [ruleId, application.capabilities.actions.show, displayActionsOptions, displayResponseActionsOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepRuleActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, displayActionsDropDown))));
};
const StepRuleActions = exports.StepRuleActions = /*#__PURE__*/(0, _react.memo)(StepRuleActionsComponent);
const StepRuleActionsReadOnlyComponent = ({
  addPadding,
  defaultValues: ruleActionsData
}) => {
  const {
    services: {
      triggersActionsUi
    }
  } = (0, _kibana.useKibana)();
  const actionTypeRegistry = triggersActionsUi.actionTypeRegistry;
  const {
    data: connectors
  } = (0, _use_fetch_connectors_query.useFetchConnectorsQuery)();
  const {
    data: connectorTypes
  } = (0, _use_fetch_connector_types_query.useFetchConnectorTypesQuery)();
  const notificationActions = ruleActionsData.actions;
  const responseActions = ruleActionsData.responseActions || [];
  const ruleHasActions = notificationActions.length > 0 || responseActions.length > 0;
  if (!ruleHasActions || !connectors || !connectorTypes) {
    return null;
  }
  const hasBothNotificationAndResponseActions = notificationActions.length > 0 && responseActions.length > 0;
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: addPadding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 5
    }
  }, notificationActions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, i18n.NOTIFICATION_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  })), notificationActions.map((action, index) => {
    const isLastItem = index === notificationActions.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_notification_action.NotificationAction, {
      action: action,
      connectorTypes: connectorTypes,
      connectors: connectors,
      actionTypeRegistry: actionTypeRegistry,
      key: action.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 13
      }
    }), !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 29
      }
    }));
  }), hasBothNotificationAndResponseActions && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 49
    }
  }), responseActions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, i18n.RESPONSE_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  })), responseActions.map((action, index) => {
    const isLastItem = index === responseActions.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_response_action.ResponseAction, {
      action: action,
      key: `${action.actionTypeId}-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }), !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 29
      }
    }));
  }));
};
const StepRuleActionsReadOnly = exports.StepRuleActionsReadOnly = /*#__PURE__*/(0, _react.memo)(StepRuleActionsReadOnlyComponent);