"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchMappingEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _threat_match_mapping_validator_factory = require("./validators/threat_match_mapping_validator_factory");
var _threat_match_mapping_field = require("./threat_match_mapping_field");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/threat_match_mapping_edit/threat_match_mapping_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ThreatMatchMappingEdit = exports.ThreatMatchMappingEdit = /*#__PURE__*/(0, _react.memo)(function ThreatMatchMappingEdit({
  path,
  indexPatterns,
  threatIndexPatterns
}) {
  const fieldConfig = (0, _react.useMemo)(() => ({
    label: i18n.THREAT_MATCH_MAPPING_FIELD_LABEL,
    validations: [{
      validator: (0, _threat_match_mapping_validator_factory.threatMatchMappingValidatorFactory)({
        indexPatterns,
        threatIndexPatterns
      })
    }]
  }), [indexPatterns, threatIndexPatterns]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: path,
    config: fieldConfig,
    component: _threat_match_mapping_field.ThreatMatchMappingField,
    componentProps: {
      indexPatterns,
      threatIndexPatterns
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
});