"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectFieldsAutocomplete = exports.MultiSelectAutocompleteComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/multi_select_fields/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIELD_COMBO_BOX_WIDTH = 410;
const fieldDescribedByIds = 'detectionEngineMultiSelectAutocompleteField';
const MultiSelectAutocompleteComponent = ({
  browserFields,
  isDisabled,
  field,
  fullWidth = false,
  dataTestSubj
}) => {
  const comboBoxRef = (0, _react.useRef)();
  const fieldEuiFieldProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(browserField => ({
      label: browserField.name
    })),
    placeholder: _translations.FIELD_PLACEHOLDER,
    onCreateOption: undefined,
    ...(fullWidth ? {} : {
      style: {
        width: `${FIELD_COMBO_BOX_WIDTH}px`
      }
    }),
    isDisabled,
    ref: comboBoxRef
  }), [browserFields, isDisabled, fullWidth, comboBoxRef]);

  /**
   * ComboBox's options list might stay open after disabling the control.
   *
   * It happens for example when disabled state condition depends on the number of selected items.
   * When removing the last item the control switches to disabled state but doesn't close the
   * options lits.
   */
  (0, _react.useEffect)(() => {
    if (isDisabled) {
      var _comboBoxRef$current;
      (_comboBoxRef$current = comboBoxRef.current) === null || _comboBoxRef$current === void 0 ? void 0 : _comboBoxRef$current.closeList();
    }
  }, [isDisabled]);
  return /*#__PURE__*/_react.default.createElement(_components.ComboBoxField, {
    field: field,
    idAria: fieldDescribedByIds,
    euiFieldProps: fieldEuiFieldProps,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
};
exports.MultiSelectAutocompleteComponent = MultiSelectAutocompleteComponent;
const MultiSelectFieldsAutocomplete = exports.MultiSelectFieldsAutocomplete = /*#__PURE__*/_react.default.memo(MultiSelectAutocompleteComponent);