"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldComparisonSide = FieldComparisonSide;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _versions_picker = require("./versions_picker/versions_picker");
var _field_upgrade_side_header = require("../field_upgrade_side_header");
var _field_upgrade_context = require("../rule_upgrade/field_upgrade_context");
var _utils = require("./utils");
var _get_subfield_changes = require("./get_subfield_changes");
var _subfield_changes = require("./subfield_changes");
var _comparison_side_help_info = require("./comparison_side_help_info");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/comparison_side/field_comparison_side.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldComparisonSide() {
  const {
    fieldName,
    fieldDiff,
    finalDiffableRule,
    hasResolvedValueDifferentFromSuggested
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  const resolvedValue = finalDiffableRule[fieldName];
  const options = (0, _utils.getComparisonOptionsForDiffOutcome)(fieldDiff.diff_outcome, fieldDiff.conflict, hasResolvedValueDifferentFromSuggested);
  const [selectedOption, setSelectedOption] = (0, _react.useState)(options[0]);
  const [oldVersionType, newVersionType] = (0, _utils.getVersionsForComparison)(selectedOption, fieldDiff.has_base_version);
  const oldFieldValue = (0, _utils.pickFieldValueForVersion)(oldVersionType, fieldDiff, resolvedValue);
  const newFieldValue = (0, _utils.pickFieldValueForVersion)(newVersionType, fieldDiff, resolvedValue);
  const subfieldChanges = (0, _get_subfield_changes.getSubfieldChanges)(fieldName, oldFieldValue, newFieldValue);

  /* Change selected option to "My changes" if user has modified resolved value */
  const prevResolvedValue = (0, _usePrevious.default)(resolvedValue);
  (0, _react.useEffect)(() => {
    if (selectedOption !== _versions_picker.VersionsPickerOptionEnum.MyChanges && prevResolvedValue !== undefined && !(0, _lodash.isEqual)(prevResolvedValue, resolvedValue)) {
      setSelectedOption(_versions_picker.VersionsPickerOptionEnum.MyChanges);
    }
  }, [selectedOption, prevResolvedValue, resolvedValue]);
  return /*#__PURE__*/_react.default.createElement("section", {
    "data-test-subj": `${(0, _lodash.snakeCase)(fieldName)}-comparisonSide`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_upgrade_side_header.FieldUpgradeSideHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, i18n.TITLE, /*#__PURE__*/_react.default.createElement(_comparison_side_help_info.ComparisonSideHelpInfo, {
    options: options,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_versions_picker.VersionsPicker, {
    options: options,
    selectedOption: selectedOption,
    onChange: setSelectedOption,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
    sectionName: i18n.TITLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_subfield_changes.SubfieldChanges, {
    fieldName: fieldName,
    subfieldChanges: subfieldChanges,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })));
}