"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreMappingEdit = RiskScoreMappingEdit;
exports.riskScoreMappingDeserializer = riskScoreMappingDeserializer;
exports.riskScoreMappingSerializer = riskScoreMappingSerializer;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _risk_score_override = require("../../../../../../rule_creation_ui/components/risk_score_mapping/risk_score_override");
var _use_default_index_pattern = require("../../../../../hooks/use_default_index_pattern");
var _utils = require("../utils");
var _form = require("../../../../../../rule_creation_ui/pages/form");
var _helpers = require("../../../../../../rule_creation_ui/pages/rule_creation/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/risk_score_mapping.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RiskScoreMappingEdit({
  finalDiffableRule
}) {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "riskScoreMapping",
    component: RiskScoreMappingField,
    componentProps: {
      finalDiffableRule
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  });
}
function RiskScoreMappingField({
  field,
  finalDiffableRule
}) {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const indexPatternParameters = (0, _utils.getUseRuleIndexPatternParameters)(finalDiffableRule, defaultIndexPattern);
  const {
    indexPattern,
    isIndexPatternLoading
  } = (0, _form.useRuleIndexPattern)(indexPatternParameters);
  const {
    value,
    setValue
  } = field;
  const handleToggleMappingChecked = (0, _react.useCallback)(() => {
    setValue(prevValue => ({
      ...prevValue,
      isMappingChecked: !prevValue.isMappingChecked
    }));
  }, [setValue]);
  const handleMappingChange = (0, _react.useCallback)(([newField]) => {
    var _newField$name;
    const mapping = [{
      field: (_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '',
      operator: 'equals',
      value: ''
    }];
    setValue(prevValue => ({
      ...prevValue,
      mapping
    }));
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_risk_score_override.RiskScoreOverride, {
    isMappingChecked: value.isMappingChecked,
    mapping: value.mapping,
    onToggleMappingChecked: handleToggleMappingChecked,
    onMappingChange: handleMappingChange,
    indices: indexPattern,
    isDisabled: isIndexPatternLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  });
}
function riskScoreMappingDeserializer(defaultValue) {
  return {
    riskScoreMapping: {
      isMappingChecked: defaultValue.risk_score_mapping.length > 0,
      mapping: defaultValue.risk_score_mapping
    }
  };
}
function riskScoreMappingSerializer(formData) {
  return {
    risk_score_mapping: formData.riskScoreMapping.isMappingChecked ? (0, _helpers.filterOutEmptyRiskScoreMappingItems)(formData.riskScoreMapping.mapping) : []
  };
}