"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOLVABLE_CONFLICT_DESCRIPTION = exports.SOLVABLE_CONFLICT = exports.SEPARATOR = exports.SAME_UPDATE_DESCRIPTION = exports.SAME_UPDATE = exports.REVIEWED_AND_ACCEPTED = exports.NO_UPDATE_DESCRIPTION = exports.NO_UPDATE = exports.NO_CONFLICT_DESCRIPTION = exports.NO_CONFLICT = exports.NON_SOLVABLE_CONFLICT_DESCRIPTION = exports.NON_SOLVABLE_CONFLICT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_UPDATE = exports.NO_UPDATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.noUpdate', {
  defaultMessage: 'No update'
});
const NO_UPDATE_DESCRIPTION = exports.NO_UPDATE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.noUpdateDescription', {
  defaultMessage: 'This field has no Elastic update but can still be edited if needed.'
});
const SAME_UPDATE = exports.SAME_UPDATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.sameUpdate', {
  defaultMessage: 'Matching update'
});
const SAME_UPDATE_DESCRIPTION = exports.SAME_UPDATE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.sameUpdateDescription', {
  defaultMessage: 'The field was modified after rule installation, and your changes are the same as the update from Elastic.'
});
const NO_CONFLICT = exports.NO_CONFLICT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.noConflict', {
  defaultMessage: 'No conflicts'
});
const NO_CONFLICT_DESCRIPTION = exports.NO_CONFLICT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.noConflictDescription', {
  defaultMessage: "There are no conflicts with the field's current value and incoming Elastic update."
});
const REVIEWED_AND_ACCEPTED = exports.REVIEWED_AND_ACCEPTED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.reviewedAndAccepted', {
  defaultMessage: 'Reviewed and accepted'
});
const SOLVABLE_CONFLICT = exports.SOLVABLE_CONFLICT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.solvableConflict', {
  defaultMessage: 'Auto-resolved conflict'
});
const SOLVABLE_CONFLICT_DESCRIPTION = exports.SOLVABLE_CONFLICT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.solvableConflictDescription', {
  defaultMessage: "We combined your changes with changes from the Elastic update. Review the suggested changes to ensure they're correct."
});
const NON_SOLVABLE_CONFLICT = exports.NON_SOLVABLE_CONFLICT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.nonSolvableConflict', {
  defaultMessage: 'Unresolved conflict'
});
const NON_SOLVABLE_CONFLICT_DESCRIPTION = exports.NON_SOLVABLE_CONFLICT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.nonSolvableConflictDescription', {
  defaultMessage: "We couldn't resolve this conflict. Edit the provided current version before saving and accepting the final update."
});
const SEPARATOR = exports.SEPARATOR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.fieldUpgradeState.separator', {
  defaultMessage: ' - '
});