"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleSnoozeSettings = useRuleSnoozeSettings;
var _use_fetch_rules_snooze_settings_query = require("../../api/hooks/use_fetch_rules_snooze_settings_query");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRuleSnoozeSettings(id) {
  var _useRulesTableContext, _rulesTableSnoozeSett;
  const {
    state: {
      rulesSnoozeSettings: rulesTableSnoozeSettings
    }
  } = (_useRulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)()) !== null && _useRulesTableContext !== void 0 ? _useRulesTableContext : {
    state: {}
  };
  const {
    data: rulesSnoozeSettings,
    isFetching: isSingleSnoozeSettingsFetching,
    isError: isSingleSnoozeSettingsError
  } = (0, _use_fetch_rules_snooze_settings_query.useFetchRulesSnoozeSettingsQuery)([id], {
    enabled: !(rulesTableSnoozeSettings !== null && rulesTableSnoozeSettings !== void 0 && rulesTableSnoozeSettings.data[id]) && !(rulesTableSnoozeSettings !== null && rulesTableSnoozeSettings !== void 0 && rulesTableSnoozeSettings.isFetching)
  });
  const snoozeSettings = (_rulesTableSnoozeSett = rulesTableSnoozeSettings === null || rulesTableSnoozeSettings === void 0 ? void 0 : rulesTableSnoozeSettings.data[id]) !== null && _rulesTableSnoozeSett !== void 0 ? _rulesTableSnoozeSett : rulesSnoozeSettings === null || rulesSnoozeSettings === void 0 ? void 0 : rulesSnoozeSettings[id];
  const isFetching = (rulesTableSnoozeSettings === null || rulesTableSnoozeSettings === void 0 ? void 0 : rulesTableSnoozeSettings.isFetching) || isSingleSnoozeSettingsFetching;
  const isError = (rulesTableSnoozeSettings === null || rulesTableSnoozeSettings === void 0 ? void 0 : rulesTableSnoozeSettings.isError) || isSingleSnoozeSettingsError;
  return {
    snoozeSettings,
    error: isError || !snoozeSettings && !isFetching ? i18n.UNABLE_TO_FETCH_RULES_SNOOZE_SETTINGS : undefined
  };
}