"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpgradeSecurityPackages = exports.useIsUpgradingSecurityPackages = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _use_bootstrap_prebuilt_rules = require("../api/hooks/prebuilt_rules/use_bootstrap_prebuilt_rules");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Install or upgrade the security packages (endpoint and prebuilt rules)
 */
const useUpgradeSecurityPackages = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    mutate: bootstrapPrebuiltRules
  } = (0, _use_bootstrap_prebuilt_rules.useBootstrapPrebuiltRulesMutation)({
    onError: error => {
      addError(error, {
        title: i18n.BOOTSTRAP_PREBUILT_RULES_FAILURE
      });
    },
    onSuccess: ({
      rules
    }) => {
      if (rules !== null && rules !== void 0 && rules.errors.length) {
        addError(new Error(rules.errors.map(error => error.message).join('; ')), {
          title: i18n.BOOTSTRAP_PREBUILT_RULES_FAILURE
        });
      }
    }
  });
  (0, _react.useEffect)(() => {
    bootstrapPrebuiltRules();
  }, [bootstrapPrebuiltRules]);
};

/**
 * @returns true if the security packages are being installed or upgraded
 */
exports.useUpgradeSecurityPackages = useUpgradeSecurityPackages;
const useIsUpgradingSecurityPackages = () => {
  const bootstrappingRules = (0, _reactQuery.useIsMutating)({
    mutationKey: _use_bootstrap_prebuilt_rules.BOOTSTRAP_PREBUILT_RULES_KEY
  });
  return bootstrappingRules > 0;
};
exports.useIsUpgradingSecurityPackages = useIsUpgradingSecurityPackages;