"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionDryRunConfirmation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _bulk_action_rule_errors_list = require("./bulk_action_rule_errors_list");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _utility_types = require("../../../../../../common/utility_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/bulk_action_dry_run_confirmation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getActionRejectedTitle = (bulkAction, failedRulesCount) => {
  switch (bulkAction) {
    case _rule_management.BulkActionTypeEnum.edit:
      return i18n.BULK_EDIT_CONFIRMATION_REJECTED_TITLE(failedRulesCount);
    case _rule_management.BulkActionTypeEnum.export:
      return i18n.BULK_EXPORT_CONFIRMATION_REJECTED_TITLE(failedRulesCount);
    case _rule_management.BulkActionTypeEnum.run:
      return i18n.BULK_MANUAL_RULE_RUN_CONFIRMATION_REJECTED_TITLE(failedRulesCount);
    case _rule_management.BulkActionTypeEnum.fill_gaps:
      return i18n.BULK_FILL_RULE_GAPS_CONFIRMATION_REJECTED_TITLE(failedRulesCount);
    default:
      (0, _utility_types.assertUnreachable)(bulkAction);
  }
};
const getActionConfirmLabel = (bulkAction, succeededRulesCount) => {
  switch (bulkAction) {
    case _rule_management.BulkActionTypeEnum.edit:
      return i18n.BULK_EDIT_CONFIRMATION_CONFIRM(succeededRulesCount);
    case _rule_management.BulkActionTypeEnum.export:
      return i18n.BULK_EXPORT_CONFIRMATION_CONFIRM(succeededRulesCount);
    case _rule_management.BulkActionTypeEnum.run:
      return i18n.BULK_MANUAL_RULE_RUN_CONFIRMATION_CONFIRM(succeededRulesCount);
    case _rule_management.BulkActionTypeEnum.fill_gaps:
      return i18n.BULK_FILL_RULE_GAPS_CONFIRMATION_CONFIRM;
    default:
      (0, _utility_types.assertUnreachable)(bulkAction);
  }
};
const BulkActionDryRunConfirmationComponent = ({
  onCancel,
  onConfirm,
  result,
  bulkAction
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    failedRulesCount = 0,
    succeededRulesCount = 0,
    ruleErrors = []
  } = result !== null && result !== void 0 ? result : {};

  // if no rule can be edited, modal window that denies bulk edit action will be displayed
  if (succeededRulesCount === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: getActionRejectedTitle(bulkAction, failedRulesCount),
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: onCancel,
      onConfirm: onCancel,
      confirmButtonText: i18n.BULK_ACTION_CONFIRMATION_CLOSE,
      defaultFocusedButton: "confirm",
      "data-test-subj": "bulkActionRejectModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_bulk_action_rule_errors_list.BulkActionRuleErrorsList, {
      bulkAction: bulkAction,
      ruleErrors: ruleErrors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }));
  }

  // if there are rules that can and cannot be edited, modal window that propose edit of some the rules will be displayed
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: i18n.BULK_ACTION_CONFIRMATION_PARTLY_TITLE(succeededRulesCount),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: getActionConfirmLabel(bulkAction, succeededRulesCount),
    cancelButtonText: i18n.BULK_EDIT_CONFIRMATION_CANCEL,
    defaultFocusedButton: "confirm",
    "data-test-subj": "bulkActionConfirmationModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_bulk_action_rule_errors_list.BulkActionRuleErrorsList, {
    bulkAction: bulkAction,
    ruleErrors: ruleErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }));
};
const BulkActionDryRunConfirmation = exports.BulkActionDryRunConfirmation = /*#__PURE__*/_react.default.memo(BulkActionDryRunConfirmationComponent);
BulkActionDryRunConfirmation.displayName = 'BulkActionDryRunConfirmation';