"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkEditFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _index_patterns_form = require("./forms/index_patterns_form");
var _tags_form = require("./forms/tags_form");
var _timeline_template_form = require("./forms/timeline_template_form");
var _rule_actions_form = require("./forms/rule_actions_form");
var _schedule_form = require("./forms/schedule_form");
var _investigation_fields_form = require("./forms/investigation_fields_form");
var _set_alert_suppression_form = require("./forms/set_alert_suppression_form");
var _set_alert_suppression_for_threshold_form = require("./forms/set_alert_suppression_for_threshold_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/bulk_edit_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BulkEditFlyoutComponent = ({
  editAction,
  ...props
}) => {
  switch (editAction) {
    case _rule_management.BulkActionEditTypeEnum.add_index_patterns:
    case _rule_management.BulkActionEditTypeEnum.delete_index_patterns:
    case _rule_management.BulkActionEditTypeEnum.set_index_patterns:
      return /*#__PURE__*/_react.default.createElement(_index_patterns_form.IndexPatternsForm, (0, _extends2.default)({}, props, {
        editAction: editAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 14
        }
      }));
    case _rule_management.BulkActionEditTypeEnum.add_tags:
    case _rule_management.BulkActionEditTypeEnum.delete_tags:
    case _rule_management.BulkActionEditTypeEnum.set_tags:
      return /*#__PURE__*/_react.default.createElement(_tags_form.TagsForm, (0, _extends2.default)({}, props, {
        editAction: editAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 14
        }
      }));
    case _rule_management.BulkActionEditTypeEnum.add_investigation_fields:
    case _rule_management.BulkActionEditTypeEnum.delete_investigation_fields:
    case _rule_management.BulkActionEditTypeEnum.set_investigation_fields:
      return /*#__PURE__*/_react.default.createElement(_investigation_fields_form.InvestigationFieldsForm, (0, _extends2.default)({}, props, {
        editAction: editAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 14
        }
      }));
    case _rule_management.BulkActionEditTypeEnum.set_alert_suppression:
      return /*#__PURE__*/_react.default.createElement(_set_alert_suppression_form.SetAlertSuppressionForm, (0, _extends2.default)({}, props, {
        editAction: editAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 14
        }
      }));
    case _rule_management.BulkActionEditTypeEnum.set_alert_suppression_for_threshold:
      return /*#__PURE__*/_react.default.createElement(_set_alert_suppression_for_threshold_form.SetAlertSuppressionForThresholdForm, (0, _extends2.default)({}, props, {
        editAction: editAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 14
        }
      }));
    case _rule_management.BulkActionEditTypeEnum.set_timeline:
      return /*#__PURE__*/_react.default.createElement(_timeline_template_form.TimelineTemplateForm, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 14
        }
      }));
    case _rule_management.BulkActionEditTypeEnum.add_rule_actions:
    case _rule_management.BulkActionEditTypeEnum.set_rule_actions:
      return /*#__PURE__*/_react.default.createElement(_rule_actions_form.RuleActionsForm, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 14
        }
      }));
    case _rule_management.BulkActionEditTypeEnum.set_schedule:
      return /*#__PURE__*/_react.default.createElement(_schedule_form.ScheduleForm, (0, _extends2.default)({}, props, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 14
        }
      }));
    default:
      return null;
  }
};
const BulkEditFlyout = exports.BulkEditFlyout = /*#__PURE__*/_react.default.memo(BulkEditFlyoutComponent);
BulkEditFlyout.displayName = 'BulkEditFlyout';