"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalToolbarControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_get_group_selector = require("@kbn/grouping/src/hooks/use_get_group_selector");
var _const = require("@kbn/grouping/src/telemetry/const");
var _eui = require("@elastic/eui");
var _selectors = require("../../../common/store/grouping/selectors");
var _containers = require("../../../sourcerer/containers");
var _model = require("../../../sourcerer/store/model");
var _summary_view_select = require("../../../common/components/events_viewer/summary_view_select");
var _actions = require("../../../common/store/grouping/actions");
var _kibana = require("../../../common/lib/kibana");
var _telemetry = require("../../../common/lib/telemetry");
var _use_data_table_filters = require("../../../common/hooks/use_data_table_filters");
var _use_selector = require("../../../common/hooks/use_selector");
var _additional_filters_action = require("./additional_filters_action");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/additional_toolbar_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  changeViewMode
} = _securitysolutionDataTable.dataTableActions;
const AdditionalToolbarControlsComponent = ({
  tableType
}) => {
  var _useDeepEqualSelector;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    services: {
      telemetry
    }
  } = (0, _kibana.useKibana)();
  const {
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const isNewDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const groupId = (0, _react.useMemo)(() => (0, _selectors.groupIdSelector)(), []);
  const {
    options
  } = (_useDeepEqualSelector = (0, _use_selector.useDeepEqualSelector)(state => groupId(state, tableType))) !== null && _useDeepEqualSelector !== void 0 ? _useDeepEqualSelector : {
    options: []
  };
  const trackGroupChange = (0, _react.useCallback)(groupSelection => {
    _telemetry.track === null || _telemetry.track === void 0 ? void 0 : (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _const.getTelemetryEvent.groupChanged({
      groupingId: tableType,
      selected: groupSelection
    }));
    telemetry.reportEvent(_telemetry.AlertsEventTypes.AlertsGroupingChanged, {
      groupByField: groupSelection,
      tableId: tableType
    });
  }, [tableType, telemetry]);
  const onGroupChange = (0, _react.useCallback)(selectedGroups => {
    selectedGroups.forEach(g => trackGroupChange(g));
    dispatch((0, _actions.updateGroups)({
      activeGroups: selectedGroups,
      tableId: tableType
    }));
  }, [dispatch, tableType, trackGroupChange]);
  const fields = (0, _react.useMemo)(() => isNewDataViewPickerEnabled ? experimentalDataView.fields.map(field => field.spec) : Object.values(oldSourcererDataView.fields || {}), [experimentalDataView.fields, isNewDataViewPickerEnabled, oldSourcererDataView.fields]);
  const groupSelector = (0, _use_get_group_selector.useGetGroupSelectorStateless)({
    groupingId: tableType,
    onGroupChange,
    fields,
    defaultGroupingOptions: options,
    maxGroupingLevels: 3
  });
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const tableView = (0, _use_selector.useShallowEqualSelector)(state => {
    var _viewMode, _getTable;
    return (_viewMode = ((_getTable = getTable(state, tableType)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode) !== null && _viewMode !== void 0 ? _viewMode : _securitysolutionDataTable.tableDefaults.viewMode;
  });
  const handleChangeTableView = (0, _react.useCallback)(selectedView => {
    dispatch(changeViewMode({
      id: tableType,
      viewMode: selectedView
    }));
  }, [dispatch, tableType]);
  const {
    showBuildingBlockAlerts,
    setShowBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts,
    setShowOnlyThreatIndicatorAlerts
  } = (0, _use_data_table_filters.useDataTableFilters)(tableType);
  const additionalFiltersComponent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_additional_filters_action.AdditionalFiltersAction, {
    areEventsLoading: false,
    onShowBuildingBlockAlertsChanged: setShowBuildingBlockAlerts,
    showBuildingBlockAlerts: showBuildingBlockAlerts,
    onShowOnlyThreatIndicatorAlertsChanged: setShowOnlyThreatIndicatorAlerts,
    showOnlyThreatIndicatorAlerts: showOnlyThreatIndicatorAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), [showBuildingBlockAlerts, setShowBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, setShowOnlyThreatIndicatorAlerts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, [_securitysolutionDataTable.TableId.alertsOnRuleDetailsPage, _securitysolutionDataTable.TableId.alertsOnAlertsPage].includes(tableType) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "summary-view-selector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_summary_view_select.SummaryViewSelector, {
    viewSelected: tableView,
    onViewChange: handleChangeTableView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, additionalFiltersComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, groupSelector));
};
const AdditionalToolbarControls = exports.AdditionalToolbarControls = /*#__PURE__*/(0, _react.memo)(AdditionalToolbarControlsComponent);