"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateInTimelineAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _action_icon_item = require("../../../../common/components/header_actions/action_icon_item");
var _user_privileges = require("../../../../common/components/user_privileges");
var _translations = require("../translations");
var _use_investigate_in_timeline = require("./use_investigate_in_timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/investigate_in_timeline_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InvestigateInTimelineActionComponent = ({
  ariaLabel = _translations.ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL,
  ecsRowData,
  buttonType,
  onInvestigateInTimelineAlertClick
}) => {
  const {
    investigateInTimelineAlertClick
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    ecsRowData,
    onInvestigateInTimelineAlertClick
  });
  const {
    timelinePrivileges: {
      read
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const cannotReadTimeline = !read;
  return /*#__PURE__*/_react.default.createElement(_action_icon_item.ActionIconItem, {
    ariaLabel: ariaLabel,
    content: _translations.ACTION_INVESTIGATE_IN_TIMELINE,
    dataTestSubj: "send-alert-to-timeline",
    iconType: "timeline",
    onClick: investigateInTimelineAlertClick,
    isDisabled: cannotReadTimeline,
    buttonType: buttonType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
const InvestigateInTimelineAction = exports.InvestigateInTimelineAction = /*#__PURE__*/_react.default.memo(InvestigateInTimelineActionComponent);