"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineStatusHeaderAction = EngineStatusHeaderAction;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_entity_store = require("../../../hooks/use_entity_store");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/components/engines_status/components/engine_status_header_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EngineStatusHeaderAction({
  engine,
  type
}) {
  var _engine$components;
  const enableEntityStore = (0, _use_entity_store.useEnableEntityStoreMutation)();
  const installEntityStore = () => {
    enableEntityStore.mutate({
      entityTypes: [type]
    });
  };
  const hasUninstalledComponent = engine === null || engine === void 0 ? void 0 : (_engine$components = engine.components) === null || _engine$components === void 0 ? void 0 : _engine$components.some(({
    installed
  }) => !installed);
  if (enableEntityStore.isLoading || (0, _helpers.isEngineLoading)(engine === null || engine === void 0 ? void 0 : engine.status)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 12
      }
    });
  }
  if (!engine) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: installEntityStore,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.installButton",
      defaultMessage: "Install",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }));
  }
  if (hasUninstalledComponent) {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: installEntityStore,
      iconType: "refresh",
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.reinstallButton",
      defaultMessage: "Reinstall",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.reinstallToolTip",
        defaultMessage: "The components associated with this entity type are experiencing issues. Reinstall them to restore functionality",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }),
      color: "warning",
      position: "right",
      type: "info",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }));
  }
  return null;
}