"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionSeverityFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_access_detection/pad_chart/pad_chart_severity_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PrivilegedAccessDetectionSeverityFilter = ({
  anomalyBands,
  toggleHiddenBand
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    css: {
      fontWeight: euiTheme.font.weight.bold
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 11
    }
  }, 'Anomaly score'), anomalyBands.map(band => {
    if (band.hidden) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: `${band.start}-${band.end}`,
        css: {
          cursor: 'pointer'
        },
        onClick: () => toggleHiddenBand(band),
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: 'center',
        gutterSize: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: 'eyeClosed',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's',
        color: euiTheme.colors.textSubdued,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 23
        }
      }, `${band.start}-${band.end}`))));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      key: `${band.start}-${band.end}`,
      css: {
        cursor: 'pointer'
      },
      onClick: () => toggleHiddenBand(band),
      color: band.color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 15
      }
    }, `${band.start}-${band.end}`);
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.PrivilegedAccessDetectionSeverityFilter = PrivilegedAccessDetectionSeverityFilter;