"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToggleOptions = exports.useStackByOptions = exports.usePrivilegedUserActivityParams = exports.useDiscoverPath = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _rison = require("@kbn/rison");
var E = _interopRequireWildcard(require("fp-ts/Either"));
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _use_space_id = require("../../../../../common/hooks/use_space_id");
var _esql_data_generation = require("../../../privileged_user_monitoring_onboarding/components/sample_dashboard/esql_data_generation");
var _types = require("./types");
var _columns = require("./columns");
var _get_lens_attributes = require("./get_lens_attributes");
var _constants = require("./constants");
var _authentications_esql_query = require("../../queries/authentications_esql_query");
var _account_switches_esql_query = require("../../queries/account_switches_esql_query");
var _granted_rights_esql_query = require("../../queries/granted_rights_esql_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_user_activity/hooks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useDiscoverPath = query => {
  const {
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const discoverUrl = (0, _react.useMemo)(() => {
    try {
      const encodedAppState = (0, _rison.encode)({
        query: {
          esql: query
        }
      });
      return `#/?_a=${encodedAppState}`;
    } catch (error) {
      addWarning(error, {
        title: _constants.ERROR_ENCODING_ESQL_QUERY
      });
      return '#/'; // Fallback to root if encoding fails
    }
  }, [query, addWarning]);
  return discoverUrl;
};
exports.useDiscoverPath = useDiscoverPath;
const toggleOptionsConfig = {
  [_types.VisualizationToggleOptions.GRANTED_RIGHTS]: {
    generateEsqlSource: _granted_rights_esql_query.getGrantedRightsEsqlSource,
    buildColumns: _columns.buildGrantedRightsColumns,
    stackByOptions: _constants.GRANTED_RIGHTS_STACK_BY
  },
  [_types.VisualizationToggleOptions.ACCOUNT_SWITCHES]: {
    generateEsqlSource: _account_switches_esql_query.getAccountSwitchesEsqlSource,
    buildColumns: _columns.buildAccountSwitchesColumns,
    stackByOptions: _constants.ACCOUNT_SWITCH_STACK_BY
  },
  [_types.VisualizationToggleOptions.AUTHENTICATIONS]: {
    generateEsqlSource: _authentications_esql_query.getAuthenticationsEsqlSource,
    buildColumns: _columns.buildAuthenticationsColumns,
    stackByOptions: _constants.AUTHENTICATIONS_STACK_BY
  }
};
const usePrivilegedUserActivityParams = (selectedToggleOption, sourcererDataView) => {
  var _sourcererDataView$ti;
  const spaceId = (0, _use_space_id.useSpaceId)();
  const indexPattern = (_sourcererDataView$ti = sourcererDataView === null || sourcererDataView === void 0 ? void 0 : sourcererDataView.title) !== null && _sourcererDataView$ti !== void 0 ? _sourcererDataView$ti : '';
  const fields = sourcererDataView === null || sourcererDataView === void 0 ? void 0 : sourcererDataView.fields;
  const esqlSource = (0, _react.useMemo)(() => spaceId && indexPattern && fields ? toggleOptionsConfig[selectedToggleOption].generateEsqlSource(spaceId, indexPattern, fields) : E.left({
    error: 'GenerateEsqlSource requires spaceId, indexPattern, fields to be defined'
  }), [selectedToggleOption, spaceId, indexPattern, fields]);
  const generateTableQuery = (0, _react.useMemo)(() => (0, _esql_data_generation.generateListESQLQuery)(esqlSource), [esqlSource]);
  const generateVisualizationQuery = (0, _react.useMemo)(() => (0, _esql_data_generation.generateVisualizationESQLQuery)(esqlSource), [esqlSource]);
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const columns = (0, _react.useMemo)(() => toggleOptionsConfig[selectedToggleOption].buildColumns(openRightPanel), [selectedToggleOption, openRightPanel]);
  return {
    getLensAttributes: _get_lens_attributes.getLensAttributes,
    generateVisualizationQuery,
    generateTableQuery,
    columns
  };
};
exports.usePrivilegedUserActivityParams = usePrivilegedUserActivityParams;
const useToggleOptions = () => (0, _react.useMemo)(() => [{
  id: _types.VisualizationToggleOptions.GRANTED_RIGHTS,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.grantedRights",
    defaultMessage: "Granted rights",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })
}, {
  id: _types.VisualizationToggleOptions.ACCOUNT_SWITCHES,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.accountSwitches",
    defaultMessage: "Account switches",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })
}, {
  id: _types.VisualizationToggleOptions.AUTHENTICATIONS,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.authentications",
    defaultMessage: "Authentications",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  })
}], []);
exports.useToggleOptions = useToggleOptions;
const useStackByOptions = selectedToggleOption => toggleOptionsConfig[selectedToggleOption].stackByOptions;
exports.useStackByOptions = useStackByOptions;