"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreEnableSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _engine_status_route = require("../../../../common/api/entity_analytics/risk_engine/engine_status_route.gen");
var i18n = _interopRequireWildcard(require("../../translations"));
var _use_risk_engine_status = require("../../api/hooks/use_risk_engine_status");
var _use_init_risk_engine_mutation = require("../../api/hooks/use_init_risk_engine_mutation");
var _use_enable_risk_engine_mutation = require("../../api/hooks/use_enable_risk_engine_mutation");
var _use_disable_risk_engine_mutation = require("../../api/hooks/use_disable_risk_engine_mutation");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _risk_score_configurable_risk_engine_settings_hooks = require("./hooks/risk_score_configurable_risk_engine_settings_hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_score_management/risk_score_enable_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MIN_WIDTH_TO_PREVENT_LABEL_FROM_MOVING = '50px';
const toastOptions = {
  toastLifeTimeMs: 5000
};
const RiskScoreErrorPanel = ({
  errors
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: i18n.ERROR_PANEL_TITLE,
  color: "danger",
  iconType: "error",
  "data-test-subj": "risk-score-error-panel",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 7
  }
}, i18n.ERROR_PANEL_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
  id: "risk-engine-erros",
  buttonContent: i18n.ERROR_PANEL_ERRORS,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors.map(error => /*#__PURE__*/_react.default.createElement("div", {
  key: error,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 15
  }
}, error), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 15
  }
})))))));
const RiskEngineHealth = ({
  currentRiskEngineStatus
}) => {
  if (!currentRiskEngineStatus) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 12
      }
    }, '-');
  }
  if (currentRiskEngineStatus === _engine_status_route.RiskEngineStatusEnum.ENABLED) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 12
      }
    }, i18n.RISK_ENGINE_STATUS_ON);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 10
    }
  }, i18n.RISK_ENGINE_STATUS_OFF);
};
const RiskEngineStatusRow = ({
  currentRiskEngineStatus,
  onSwitchClick,
  isLoading,
  privileges
}) => {
  const userHasRequiredPrivileges = 'hasAllRequiredPrivileges' in privileges && privileges.hasAllRequiredPrivileges;
  const btnIsDisabled = !currentRiskEngineStatus || isLoading || !userHasRequiredPrivileges;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "risk-score-status-loading",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: MIN_WIDTH_TO_PREVENT_LABEL_FROM_MOVING
    },
    "data-test-subj": "risk-score-status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(RiskEngineHealth, {
    currentRiskEngineStatus: currentRiskEngineStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    justifyContent: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: i18n.RISK_ENGINE_STATUS_SWITCH_LABEL,
    "data-test-subj": "risk-score-switch",
    checked: currentRiskEngineStatus === _engine_status_route.RiskEngineStatusEnum.ENABLED,
    onChange: onSwitchClick,
    disabled: btnIsDisabled,
    "aria-describedby": 'switchRiskModule',
    showLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })));
};
const RiskScoreEnableSection = ({
  privileges,
  selectedSettingsMatchSavedSettings,
  saveSelectedSettingsMutation
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    data: riskEngineStatus,
    isFetching: isStatusLoading
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const invalidateRiskEngineSettingsQuery = (0, _risk_score_configurable_risk_engine_settings_hooks.useInvalidateRiskEngineSettingsQuery)();
  const initRiskEngineMutation = (0, _use_init_risk_engine_mutation.useInitRiskEngineMutation)({
    onSuccess: async () => {
      await invalidateRiskEngineSettingsQuery();
      addSuccess(i18n.RISK_ENGINE_TURNED_ON, toastOptions);
    }
  });
  const enableRiskEngineMutation = (0, _use_enable_risk_engine_mutation.useEnableRiskEngineMutation)({
    onSuccess: () => {
      addSuccess(i18n.RISK_ENGINE_TURNED_ON, toastOptions);
    }
  });
  const disableRiskEngineMutation = (0, _use_disable_risk_engine_mutation.useDisableRiskEngineMutation)({
    onSuccess: () => {
      addSuccess(i18n.RISK_ENGINE_TURNED_OFF, toastOptions);
    }
  });
  const currentRiskEngineStatus = riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status;
  const isLoading = saveSelectedSettingsMutation.isLoading || initRiskEngineMutation.isLoading || enableRiskEngineMutation.isLoading || disableRiskEngineMutation.isLoading || privileges.isLoading || isStatusLoading;
  const onSwitchClick = async () => {
    if (!currentRiskEngineStatus || isLoading) {
      return;
    }
    if (currentRiskEngineStatus === _engine_status_route.RiskEngineStatusEnum.NOT_INSTALLED) {
      if (!selectedSettingsMatchSavedSettings) {
        await saveSelectedSettingsMutation.mutateAsync();
      }
      await initRiskEngineMutation.mutateAsync();
    } else if (currentRiskEngineStatus === _engine_status_route.RiskEngineStatusEnum.ENABLED) {
      disableRiskEngineMutation.mutate();
    } else if (currentRiskEngineStatus === _engine_status_route.RiskEngineStatusEnum.DISABLED) {
      enableRiskEngineMutation.mutate();
    }
  };
  let initRiskEngineErrors = [];
  if (initRiskEngineMutation.isError) {
    const errorBody = initRiskEngineMutation.error.body;
    initRiskEngineErrors = [errorBody.message];
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, initRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: initRiskEngineErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 44
    }
  }), disableRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: [disableRiskEngineMutation.error.body.message],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }), enableRiskEngineMutation.isError && /*#__PURE__*/_react.default.createElement(RiskScoreErrorPanel, {
    errors: [enableRiskEngineMutation.error.body.message],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(RiskEngineStatusRow, {
    currentRiskEngineStatus: currentRiskEngineStatus,
    onSwitchClick: onSwitchClick,
    isLoading: isLoading,
    privileges: privileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }));
};
exports.RiskScoreEnableSection = RiskScoreEnableSection;