"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationsHostTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _paginated_table = require("../paginated_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _authentications = require("../../containers/authentications");
var _manage_query = require("../../../common/components/page/manage_query");
var _store = require("../../hosts/store");
var _query_toggle = require("../../../common/containers/query_toggle");
var _use_selector = require("../../../common/hooks/use_selector");
var _search_strategy = require("../../../../common/search_strategy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/components/authentication/authentications_host_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TABLE_QUERY_ID = 'authenticationsHostsTableQuery';
const tableType = _store.hostsModel.HostsTableType.authentications;
const AuthenticationsHostTableComponent = ({
  endDate,
  filterQuery,
  indexNames,
  skip,
  startDate,
  type,
  setQuery,
  deleteQuery
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(TABLE_QUERY_ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const getAuthenticationsSelector = _store.hostsSelectors.authenticationsSelector();
  const {
    activePage,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(state => getAuthenticationsSelector(state, type));
  const [loading, {
    authentications,
    totalCount,
    pageInfo,
    loadPage,
    inspect,
    isInspected,
    refetch
  }] = (0, _authentications.useAuthentications)({
    endDate,
    filterQuery,
    indexNames,
    skip: querySkip,
    startDate,
    stackByField: _search_strategy.AuthStackByField.userName,
    activePage,
    limit
  });
  const columns = type === _store.hostsModel.HostsType.details ? (0, _helpers.getHostDetailsAuthenticationColumns)() : (0, _helpers.getHostsPageAuthenticationColumns)();
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.hostsActions.updateTableLimit({
    hostsType: type,
    limit: newLimit,
    tableType
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.hostsActions.updateTableActivePage({
    activePage: newPage,
    hostsType: type,
    tableType
  })), [type, dispatch]);
  (0, _manage_query.useQueryInspector)({
    queryId: TABLE_QUERY_ID,
    loading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: "authentications-host-table",
    headerCount: totalCount,
    headerTitle: i18n.AUTHENTICATIONS,
    headerUnit: i18n.USERS_UNIT(totalCount),
    id: TABLE_QUERY_ID,
    isInspect: isInspected,
    itemsPerRow: _helpers.rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    pageOfItems: authentications,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  });
};
AuthenticationsHostTableComponent.displayName = 'AuthenticationsHostTableComponent';
const AuthenticationsHostTable = exports.AuthenticationsHostTable = /*#__PURE__*/_react.default.memo(AuthenticationsHostTableComponent);