"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostsColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _asset_criticality = require("../../../../entity_analytics/components/asset_criticality");
var _cell_actions = require("../../../../common/components/cell_actions");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../../../common/entity_analytics/types");
var _translations2 = require("../../../../entity_analytics/components/host_risk_score_table/translations");
var _common = require("../../../../entity_analytics/components/severity/common");
var _translations3 = require("../../../../entity_analytics/components/risk_score/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/components/hosts_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getHostsColumns = (showRiskColumn, dispatchSeverityUpdate) => {
  const columns = [{
    field: 'node.host.name',
    name: i18n.NAME,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: hostName => {
      if (hostName != null && hostName.length > 0) {
        return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
          mode: _cell_actions.CellActionsMode.HOVER_DOWN,
          visibleCellActions: 5,
          showActionTooltips: true,
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          data: {
            value: hostName[0],
            field: 'host.name'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 42,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
          hostName: hostName[0],
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 15
          }
        }));
      }
      return (0, _empty_value.getEmptyTagValue)();
    },
    width: '35%'
  }, {
    field: 'node.lastSeen',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.FIRST_LAST_SEEN_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.LAST_SEEN, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "info",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 30
      }
    }))),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: lastSeen => {
      if (lastSeen != null && lastSeen.length > 0) {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
          value: Array.isArray(lastSeen) ? lastSeen[0] : lastSeen,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 13
          }
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: 'node.host.os.name',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.OS_LAST_SEEN_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.OS, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "subdued",
      type: "info",
      className: "eui-alignTop",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 23
      }
    }))),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: hostOsName => {
      if (hostOsName != null) {
        return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
          mode: _cell_actions.CellActionsMode.HOVER_DOWN,
          visibleCellActions: 5,
          showActionTooltips: true,
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          data: {
            value: hostOsName[0],
            field: 'host.os.name'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 13
          }
        }, hostOsName);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }, {
    field: 'node.host.os.version',
    name: i18n.VERSION,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: hostOsVersion => {
      if (hostOsVersion != null) {
        return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
          mode: _cell_actions.CellActionsMode.HOVER_DOWN,
          visibleCellActions: 5,
          showActionTooltips: true,
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          data: {
            value: hostOsVersion[0],
            field: 'host.os.version'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 124,
            columnNumber: 13
          }
        }, hostOsVersion);
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }];
  if (showRiskColumn) {
    columns.push({
      field: 'node.risk',
      name: (0, _translations3.ENTITY_RISK_LEVEL)(_types.EntityType.host),
      truncateText: false,
      mobileOptions: {
        show: true
      },
      sortable: false,
      render: riskScore => {
        if (riskScore != null) {
          return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
            toolTipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              onClick: () => dispatchSeverityUpdate(riskScore),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 155,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: "xs",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 156,
                columnNumber: 19
              }
            }, (0, _translations2.VIEW_HOSTS_BY_SEVERITY)(riskScore.toLowerCase()))),
            severity: riskScore,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 153,
              columnNumber: 13
            }
          });
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  columns.push({
    field: 'node.criticality',
    name: i18n.ASSET_CRITICALITY,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: assetCriticality => {
      if (!assetCriticality) return (0, _empty_value.getEmptyTagValue)();
      return /*#__PURE__*/_react.default.createElement(_asset_criticality.AssetCriticalityBadge, {
        criticalityLevel: assetCriticality,
        css: {
          verticalAlign: 'middle'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 9
        }
      });
    }
  });
  return columns;
};
exports.getHostsColumns = getHostsColumns;