"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUncommonColumnsCurated = exports.getUncommonColumns = exports.getHostNames = void 0;
var _react = _interopRequireDefault(require("react"));
var _links = require("../../../../common/components/links");
var _empty_value = require("../../../../common/components/empty_value");
var _helpers = require("../../../../common/components/tables/helpers");
var _model = require("../../store/model");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/components/uncommon_process_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getHostNames = hosts => {
  if (!hosts) return [];
  return hosts.filter(host => host.name != null && host.name[0] != null).map(host => host.name != null && host.name[0] != null ? host.name[0] : '');
};
exports.getHostNames = getHostNames;
const getUncommonColumns = () => [{
  name: i18n.NAME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '20%',
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.process.name,
    fieldName: 'process.name',
    idPrefix: `uncommon-process-table-${node._id}-processName`
  })
}, {
  align: 'right',
  name: i18n.NUMBER_OF_HOSTS,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, node.hosts != null ? node.hosts.length : (0, _empty_value.getEmptyValue)()),
  width: '8%'
}, {
  align: 'right',
  name: i18n.NUMBER_OF_INSTANCES,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _empty_value.defaultToEmptyTag)(node.instances),
  width: '8%'
}, {
  name: i18n.HOSTS,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '25%',
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: getHostNames(node.hosts),
    fieldName: 'host.name',
    idPrefix: `uncommon-process-table-${node._id}-processHost`,
    render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 27
      }
    })
  })
}, {
  name: i18n.LAST_COMMAND,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '25%',
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.process != null ? node.process.args : null,
    fieldName: 'process.args',
    idPrefix: `uncommon-process-table-${node._id}-processArgs`,
    displayCount: 1
  })
}, {
  name: i18n.LAST_USER,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.user != null ? node.user.name : null,
    fieldName: 'user.name',
    idPrefix: `uncommon-process-table-${node._id}-processUser`
  })
}];
exports.getUncommonColumns = getUncommonColumns;
const getUncommonColumnsCurated = pageType => {
  const columns = getUncommonColumns();
  if (pageType === _model.HostsType.details) {
    const columnsToRemove = new Set([i18n.HOSTS, i18n.NUMBER_OF_HOSTS]);
    return columns.filter(column => typeof column.name === 'string' && !columnsToRemove.has(column.name));
  }
  return columns;
};
exports.getUncommonColumnsCurated = getUncommonColumnsCurated;