"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapToolTipComponent = exports.MapToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _tooltip_footer = require("./tooltip_footer");
var _line_tool_tip_content = require("./line_tool_tip_content");
var _point_tool_tip_content = require("./point_tool_tip_content");
var _loader = require("../../../../../common/components/loader");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/embeddables/map_tool_tip/map_tool_tip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_FEATURE = [];
const MapToolTipComponent = ({
  closeTooltip,
  features = DEFAULT_FEATURE,
  getLayerName,
  loadFeatureProperties,
  loadFeatureGeometry
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [isLoadingNextFeature, setIsLoadingNextFeature] = (0, _react.useState)(false);
  const [isError, setIsError] = (0, _react.useState)(false);
  const [featureIndex, setFeatureIndex] = (0, _react.useState)(0);
  const [featureProps, setFeatureProps] = (0, _react.useState)([]);
  const [featureGeometry, setFeatureGeometry] = (0, _react.useState)(null);
  const [, setLayerName] = (0, _react.useState)('');
  const handleCloseTooltip = (0, _react.useCallback)(() => {
    if (closeTooltip != null) {
      closeTooltip();
      setFeatureIndex(0);
    }
  }, [closeTooltip]);
  const handlePreviousFeature = (0, _react.useCallback)(() => {
    setFeatureIndex(prevFeatureIndex => prevFeatureIndex - 1);
    setIsLoadingNextFeature(true);
  }, []);
  const handleNextFeature = (0, _react.useCallback)(() => {
    setFeatureIndex(prevFeatureIndex => prevFeatureIndex + 1);
    setIsLoadingNextFeature(true);
  }, []);
  const content = (0, _react.useMemo)(() => {
    if (isError) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceAround",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 11
        }
      }, i18n.MAP_TOOL_TIP_ERROR));
    }
    if (isLoading && !isLoadingNextFeature) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceAround",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 13
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, features.length > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, featureGeometry != null && featureGeometry.type === 'LineString' ? /*#__PURE__*/_react.default.createElement(_line_tool_tip_content.LineToolTipContent, {
      "data-test-subj": "line-tool-tip-content",
      contextId: `${features[featureIndex].layerId}-${features[featureIndex].id}-${featureIndex}`,
      featureProps: featureProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_point_tool_tip_content.PointToolTipContent, {
      "data-test-subj": "point-tool-tip-content",
      contextId: `${features[featureIndex].layerId}-${features[featureIndex].id}-${featureIndex}`,
      featureProps: featureProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_tooltip_footer.ToolTipFooter, {
      featureIndex: featureIndex,
      totalFeatures: features.length,
      previousFeature: handlePreviousFeature,
      nextFeature: handleNextFeature,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    })), isLoadingNextFeature && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
      "data-test-subj": "loading-panel",
      overlay: true,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 34
      }
    }));
  }, [featureGeometry, featureIndex, featureProps, features, handleNextFeature, handlePreviousFeature, isError, isLoading, isLoadingNextFeature]);
  (0, _react.useEffect)(() => {
    // Early return if component doesn't yet have props -- result of mounting in portal before actual rendering
    if (features.length === 0 || getLayerName == null || loadFeatureProperties == null || loadFeatureGeometry == null) {
      return;
    }

    // Separate loaders for initial load vs loading next feature to keep tooltip from drastically resizing
    if (!isLoadingNextFeature) {
      setIsLoading(true);
    }
    setIsError(false);
    const fetchFeatureProps = async () => {
      if (features[featureIndex] != null) {
        const layerId = features[featureIndex].layerId;
        const featureId = features[featureIndex].id;
        try {
          const featureGeo = loadFeatureGeometry({
            layerId,
            featureId
          });
          const [featureProperties, layerNameString] = await Promise.all([loadFeatureProperties({
            layerId,
            properties: features[featureIndex].mbProperties
          }), getLayerName(layerId)]);
          setFeatureProps(featureProperties);
          setFeatureGeometry(featureGeo);
          if (layerNameString) {
            setLayerName(layerNameString);
          }
        } catch (e) {
          setIsError(true);
        } finally {
          setIsLoading(false);
          setIsLoadingNextFeature(false);
        }
      }
    };
    fetchFeatureProps();
  }, [featureIndex, features, getLayerName, isLoadingNextFeature, loadFeatureGeometry, loadFeatureProperties]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: handleCloseTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  }, content);
};
exports.MapToolTipComponent = MapToolTipComponent;
MapToolTipComponent.displayName = 'MapToolTipComponent';
const MapToolTip = exports.MapToolTip = /*#__PURE__*/_react.default.memo(MapToolTipComponent);
MapToolTip.displayName = 'MapToolTip';