"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderedFieldValue = exports.PointToolTipContentComponent = exports.PointToolTipContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _map_config = require("../map_config");
var _empty_value = require("../../../../../common/components/empty_value");
var _page = require("../../../../../common/components/page");
var _links = require("../../../../../common/components/links");
var _default_renderer = require("../../../../../timelines/components/field_renderers/default_renderer");
var _model = require("../../../../../sourcerer/store/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/embeddables/map_tool_tip/point_tool_tip_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PointToolTipContentComponent = ({
  contextId,
  featureProps
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const featureDescriptionListItems = (0, _react.useMemo)(() => featureProps.map(featureProp => {
    var _featureProp$getRawVa;
    const key = featureProp.getPropertyKey();
    const value = (_featureProp$getRawVa = featureProp.getRawValue()) !== null && _featureProp$getRawVa !== void 0 ? _featureProp$getRawVa : [];
    return {
      title: _map_config.sourceDestinationFieldMappings[key],
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value != null ? /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
        rowItems: Array.isArray(value) ? value : [value],
        attrName: key,
        idPrefix: `map-point-tooltip-${contextId}-${key}-${value}`,
        render: item => getRenderedFieldValue(key, item),
        scopeId: newDataViewPickerEnabled ? _model.SourcererScopeName.explore : _model.SourcererScopeName.default,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 17
        }
      }) : (0, _empty_value.getEmptyTagValue)())
    };
  }), [contextId, featureProps, newDataViewPickerEnabled]);
  return /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: featureDescriptionListItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 10
    }
  });
};
exports.PointToolTipContentComponent = PointToolTipContentComponent;
PointToolTipContentComponent.displayName = 'PointToolTipContentComponent';
const PointToolTipContent = exports.PointToolTipContent = /*#__PURE__*/_react.default.memo(PointToolTipContentComponent);
PointToolTipContent.displayName = 'PointToolTipContent';
const getRenderedFieldValue = (field, value) => {
  if (value === '') {
    return (0, _empty_value.getOrEmptyTagFromValue)(value);
  } else if (['host.name'].includes(field)) {
    return /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 12
      }
    });
  } else if (['source.ip', 'destination.ip'].includes(field)) {
    const flowTarget = field.split('.')[0];
    return /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
      ip: value,
      flowTarget: flowTarget,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
};
exports.getRenderedFieldValue = getRenderedFieldValue;