"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsNetworkDetails = void 0;
var _constants = require("../../../../../common/constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnNetworkDetailsUrl = (ipAddress, tabName, flowTarget) => `${_constants.NETWORK_PATH}/ip/${ipAddress}/${flowTarget}/${tabName}`;
const navTabsNetworkDetails = (ipAddress, hasMlUserPermissions, flowTarget) => {
  const networkDetailsNavTabs = {
    [_types.NetworkDetailsRouteType.events]: {
      id: _types.NetworkDetailsRouteType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.events, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.flows]: {
      id: _types.NetworkDetailsRouteType.flows,
      name: i18n.NAVIGATION_FLOWS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.flows, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.users]: {
      id: _types.NetworkDetailsRouteType.users,
      name: i18n.NAVIGATION_USERS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.users, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.http]: {
      id: _types.NetworkDetailsRouteType.http,
      name: i18n.NAVIGATION_HTTP_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.http, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.tls]: {
      id: _types.NetworkDetailsRouteType.tls,
      name: i18n.NAVIGATION_TLS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.tls, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.anomalies]: {
      id: _types.NetworkDetailsRouteType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.anomalies, flowTarget),
      disabled: false
    }
  };
  if (!hasMlUserPermissions) {
    delete networkDetailsNavTabs.anomalies;
  }
  return networkDetailsNavTabs;
};
exports.navTabsNetworkDetails = navTabsNetworkDetails;