"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Network = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/timelines-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../data_view_manager/constants");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _constants2 = require("../../../common/store/inputs/constants");
var _types = require("../../../app/types");
var _embedded_map = require("../components/embeddables/embedded_map");
var _filters_global = require("../../../common/components/filters_global");
var _header_page = require("../../../common/components/header_page");
var _last_event_time = require("../../../common/components/last_event_time");
var _tab_navigation = require("../../../common/components/navigation/tab_navigation");
var _kpi_network = require("../components/kpi_network");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _use_global_time = require("../../../common/containers/use_global_time");
var _search_strategy = require("../../../../common/search_strategy");
var _kibana = require("../../../common/lib/kibana");
var _kuery = require("../../../common/lib/kuery");
var _store = require("../../../common/store");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _display = require("../../hosts/pages/display");
var _store2 = require("../store");
var _navigation = require("./navigation");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("./navigation/types");
var _helpers = require("../../../timelines/components/timeline/helpers");
var _containers = require("../../../sourcerer/containers");
var _use_selector = require("../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _utils = require("../../../common/components/visualization_actions/utils");
var _empty_prompt = require("../../../common/components/empty_prompt");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../data_view_manager/hooks/use_selected_patterns");
var _page_loader = require("../../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/network.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styled.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
const ID = 'NetworkQueryId';
const NetworkComponent = /*#__PURE__*/_react.default.memo(({
  hasMlUserPermissions,
  capabilitiesFetched
}) => {
  const containerElement = (0, _react.useRef)(null);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const kibana = (0, _kibana.useKibana)();
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const canUseMaps = kibana.services.application.capabilities.maps_v2.show;
  const {
    uiSettings
  } = kibana.services;
  const tabsFilters = (0, _react.useMemo)(() => {
    if (tabName === _types2.NetworkRouteType.events) {
      return [...globalFilters, ..._utils.sourceOrDestinationIpExistsFilter];
    }
    return globalFilters;
  }, [tabName, globalFilters]);
  const {
    indicesExist: oldIndicesExist,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)(_constants.DataViewManagerScopeName.explore);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.DataViewManagerScopeName.explore);
  const indicesExist = newDataViewPickerEnabled ? dataView.hasMatchedIndices() : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur, _containerElement$cur2;
    (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : (_containerElement$cur2 = _containerElement$cur.querySelector('.inspectButtonComponent:last-of-type')) === null || _containerElement$cur2 === void 0 ? void 0 : _containerElement$cur2.focus();
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const [filterQuery, kqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: oldSourcererDataView,
    dataView,
    queries: [query],
    filters: globalFilters
  }), [uiSettings, oldSourcererDataView, dataView, query, globalFilters]);
  const [tabsFilterQuery] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: oldSourcererDataView,
    dataView,
    queries: [query],
    filters: tabsFilters
  }), [uiSettings, oldSourcererDataView, dataView, query, tabsFilters]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: ID,
    filterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants2.InputsModelId.global,
    sourcererDataView: newDataViewPickerEnabled ? dataView : oldSourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.network,
      indexNames: selectedPatterns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 21
      }
    }),
    title: i18n.PAGE_TITLE,
    border: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 17
    }
  }), canUseMaps && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none",
    "data-test-subj": "conditional-embeddable-map",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_embedded_map.EmbeddedMap, {
    query: query,
    filters: globalFilters,
    startDate: from,
    endDate: to,
    setQuery: setQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_kpi_network.NetworkKpiComponent, {
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 17
    }
  })), capabilitiesFetched && !isInitializing && oldSourcererDataView ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _navigation.navTabsNetwork)(hasMlUserPermissions),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_navigation.NetworkRoutes, {
    filterQuery: tabsFilterQuery,
    from: from,
    isInitializing: isInitializing,
    indexNames: selectedPatterns,
    setQuery: setQuery,
    type: _store2.networkModel.NetworkType.page,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 19
    }
  })) : /*#__PURE__*/_react.default.createElement(_navigation.NetworkRoutesLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 17
    }
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.network,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 9
    }
  }));
});
NetworkComponent.displayName = 'NetworkComponent';
const Network = exports.Network = /*#__PURE__*/_react.default.memo(NetworkComponent);