"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _use_has_vulnerabilities = require("@kbn/cloud-security-posture/src/hooks/use_has_vulnerabilities");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_non_closed_alerts = require("../../../../cloud_security_posture/hooks/use_non_closed_alerts");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _host_overview = require("../../../../overview/components/host_overview");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _inspect = require("../../../../common/components/inspect");
var _types = require("../../../../../common/entity_analytics/types");
var _common = require("../../../../entity_analytics/components/severity/common");
var _default_renderer = require("../../../../timelines/components/field_renderers/default_renderer");
var _constants = require("../../../../common/store/inputs/constants");
var _cell_actions = require("../../shared/components/cell_actions");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _containers = require("../../../../sourcerer/containers");
var _manage_query = require("../../../../common/components/page/manage_query");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _actions = require("../../../../common/store/inputs/actions");
var _host_to_criteria = require("../../../../common/components/ml/criteria/host_to_criteria");
var _details = require("../../../../explore/hosts/containers/hosts/details");
var _related_users = require("../../../../common/containers/related_entities/related_users");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _empty_value = require("../../../../common/components/empty_value");
var _test_ids = require("./test_ids");
var _constants2 = require("../../../../timelines/components/timeline/body/renderers/constants");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("../../../../entity_analytics/components/risk_score/translations");
var _helper_hooks = require("../../../../helper_hooks");
var _preview_link = require("../../../shared/components/preview_link");
var _host_right = require("../../../entity_details/host_right");
var _host_entity_overview = require("../../right/components/host_entity_overview");
var _misconfiguration_insight = require("../../shared/components/misconfiguration_insight");
var _vulnerabilities_insight = require("../../shared/components/vulnerabilities_insight");
var _alert_count_insight = require("../../shared/components/alert_count_insight");
var _telemetry = require("../../../../common/lib/telemetry");
var _use_navigate_to_host_details = require("../../../entity_details/host_right/hooks/use_navigate_to_host_details");
var _use_risk_score = require("../../../../entity_analytics/api/hooks/use_risk_score");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/host_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HOST_DETAILS_ID = 'entities-hosts-details';
const RELATED_USERS_ID = 'entities-hosts-related-users';
const HOST_DETAILS_INSIGHTS_ID = 'host-details-insights';
const HostOverviewManage = (0, _manage_query.manageQuery)(_host_overview.HostOverview);
const RelatedUsersManage = (0, _manage_query.manageQuery)(_inspect.InspectButtonContainer);
/**
 * Host details and related users, displayed in the document details expandable flyout left section under the Insights tab, Entities tab
 */
const HostDetails = ({
  hostName,
  timestamp,
  scopeId
}) => {
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)();
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  // create a unique, but stable (across re-renders) query id
  const hostDetailsQueryId = (0, _react.useMemo)(() => `${HOST_DETAILS_ID}-${(0, _uuid.v4)()}`, []);
  const relatedUsersQueryId = (0, _react.useMemo)(() => `${RELATED_USERS_ID}-${(0, _uuid.v4)()}`, []);
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const isEntityAnalyticsAuthorized = isPlatinumOrTrialLicense && hasEntityAnalyticsCapability;
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const openHostPreview = (0, _react.useCallback)(() => {
    openPreviewPanel({
      id: _host_right.HostPreviewPanelKey,
      params: {
        hostName,
        scopeId,
        banner: _host_entity_overview.HOST_PREVIEW_BANNER
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'preview'
    });
  }, [openPreviewPanel, hostName, scopeId, telemetry]);
  const [isHostLoading, {
    inspect,
    hostDetails,
    refetch
  }] = (0, _details.useHostDetails)({
    id: hostDetailsQueryId,
    startDate: from,
    endDate: to,
    hostName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const filterQuery = (0, _react.useMemo)(() => hostName ? (0, _search_strategy.buildHostNamesFilter)([hostName]) : undefined, [hostName]);
  const {
    data: hostRisk
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _types.EntityType.host,
    skip: hostName == null,
    timerange
  });
  const hostRiskData = hostRisk && hostRisk.length > 0 ? hostRisk[0] : undefined;
  const isRiskScoreExist = !!(hostRiskData !== null && hostRiskData !== void 0 && hostRiskData.host.risk);
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field: _types.EntityIdentifierFields.hostName,
    value: hostName,
    to,
    from,
    queryId: 'HostEntityOverview'
  });
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)('host.name', hostName);
  const {
    hasVulnerabilitiesFindings
  } = (0, _use_has_vulnerabilities.useHasVulnerabilities)('host.name', hostName);
  const {
    openDetailsPanel
  } = (0, _use_navigate_to_host_details.useNavigateToHostDetails)({
    hostName,
    scopeId,
    isRiskScoreExist,
    hasMisconfigurationFindings,
    hasVulnerabilitiesFindings,
    hasNonClosedAlerts,
    isPreviewMode: true,
    // setting to true to always open a new host flyout
    contextID: HOST_DETAILS_INSIGHTS_ID
  });
  const {
    loading: isRelatedUsersLoading,
    inspect: inspectRelatedUsers,
    relatedUsers,
    totalCount,
    refetch: refetchRelatedUsers
  } = (0, _related_users.useHostRelatedUsers)({
    hostName,
    indexNames: selectedPatterns,
    from: timestamp,
    // related users are users who were successfully authenticated onto this host AFTER alert time
    skip: selectedPatterns.length === 0
  });
  const relatedUsersColumns = (0, _react.useMemo)(() => [{
    field: 'user',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedUsersNameColumnLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 11
      }
    }),
    render: user => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: _constants2.USER_NAME_FIELD_NAME,
      value: user,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
      field: _constants2.USER_NAME_FIELD_NAME,
      value: user,
      scopeId: scopeId,
      "data-test-subj": _test_ids.HOST_DETAILS_RELATED_USERS_LINK_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 15
      }
    })))
  }, {
    field: 'ip',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedUsersIpColumnLabel",
      defaultMessage: "Ip addresses",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 11
      }
    }),
    render: ips => {
      return /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
        rowItems: ips,
        attrName: _constants2.HOST_IP_FIELD_NAME,
        idPrefix: '',
        render: ip => ip == null ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
          field: _constants2.HOST_IP_FIELD_NAME,
          value: ip,
          scopeId: scopeId,
          "data-test-subj": _test_ids.HOST_DETAILS_RELATED_USERS_IP_LINK_TEST_ID,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 19
          }
        }),
        scopeId: scopeId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 13
        }
      });
    }
  }, ...(isEntityAnalyticsAuthorized ? [{
    field: 'risk',
    name: (0, _translations.ENTITY_RISK_LEVEL)(_types.EntityType.user),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: riskScore => {
      if (riskScore != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
          severity: riskScore,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 290,
            columnNumber: 26
          }
        });
      }
      return (0, _empty_value.getEmptyTagValue)();
    }
  }] : [])], [isEntityAnalyticsAuthorized, scopeId]);
  const relatedUsersCount = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.relatedUsersCountLabel",
    defaultMessage: "Related users: {count}",
    values: {
      count: totalCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 15
    }
  }))))), [totalCount]);
  const pagination = {
    pageSize: 4,
    showPerPageOptions: false
  };
  const hostLink = (0, _react.useMemo)(() => ({
    callback: openHostPreview,
    tooltip: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.entities.host.hostPreviewTitle', {
      defaultMessage: 'Preview host'
    })
  }), [openHostPreview]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.hostDetailsTitle",
    defaultMessage: "Host",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: hostName,
      iconType: 'storage',
      headerContent: relatedUsersCount,
      link: hostLink
    },
    expand: {
      expandable: true,
      expandedOnFirstRender: true
    },
    "data-test-subj": _test_ids.HOST_DETAILS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.hostDetailsInfoTitle",
    defaultMessage: "Host information",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(hostDetails),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 9
    }
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(HostOverviewManage, {
    id: hostDetailsQueryId,
    hostName: hostName,
    data: hostDetails,
    indexNames: selectedPatterns,
    jobNameById: jobNameById,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    isInDetailsSidePanel: false,
    loading: isHostLoading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    setQuery: setQuery,
    refetch: refetch,
    inspect: inspect,
    deleteQuery: deleteQuery,
    scopeId: scopeId,
    isFlyoutOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    responsive: false,
    columns: 3,
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_count_insight.AlertCountInsight, {
    fieldName: 'host.name',
    name: hostName,
    direction: "column",
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.HOST_DETAILS_ALERT_COUNT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_misconfiguration_insight.MisconfigurationsInsight, {
    fieldName: 'host.name',
    name: hostName,
    direction: "column",
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.HOST_DETAILS_MISCONFIGURATIONS_TEST_ID,
    telemetryKey: _ui_metrics.MISCONFIGURATION_INSIGHT_HOST_DETAILS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_vulnerabilities_insight.VulnerabilitiesInsight, {
    hostName: hostName,
    direction: "column",
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.HOST_DETAILS_VULNERABILITIES_TEST_ID,
    telemetryKey: _ui_metrics.VULNERABILITIES_INSIGHT_HOST_DETAILS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entities.relatedUsersTitle",
    defaultMessage: "Related users",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedUsersTooltip",
      defaultMessage: "After this event, these users logged into {hostName}. Check if this activity is normal.",
      values: {
        hostName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 441,
        columnNumber: 19
      }
    }),
    type: "info",
    color: "subdued",
    anchorClassName: "eui-alignTop",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(RelatedUsersManage, {
    id: relatedUsersQueryId,
    inspect: inspectRelatedUsers,
    loading: isRelatedUsersLoading,
    setQuery: setQuery,
    deleteQuery: deleteQuery,
    refetch: refetchRelatedUsers,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: relatedUsersColumns,
    items: relatedUsers,
    loading: isRelatedUsersLoading,
    "data-test-subj": _test_ids.HOST_DETAILS_RELATED_USERS_TABLE_TEST_ID,
    pagination: pagination,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedUsersNoDataDescription",
      defaultMessage: "No users identified",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 469,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: relatedUsersQueryId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.entities.relatedUsersInspectButtonTitle",
      defaultMessage: "Related users",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 478,
        columnNumber: 17
      }
    }),
    inspectIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 13
    }
  })))));
};
exports.HostDetails = HostDetails;
HostDetails.displayName = 'HostDetails';