"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericEntityFlyoutFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18n = require("@kbn/i18n");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _telemetry = require("../../../common/lib/telemetry");
var _take_action = require("../shared/components/take_action");
var _constants = require("./constants");
var _constants2 = require("../shared/constants");
var _constants3 = require("../../document_details/preview/constants");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("../shared/translations");
var _use_asset_inventory_assistant = require("./hooks/use_asset_inventory_assistant");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/generic_right/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GenericEntityFlyoutFooter = ({
  entityId,
  isPreviewMode,
  scopeId,
  entityFields
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    showAssistant,
    showAssistantOverlay
  } = (0, _use_asset_inventory_assistant.useAssetInventoryAssistant)({
    entityId,
    entityFields,
    isPreviewMode
  });
  const openDocumentFlyout = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _constants2.GenericEntityPanelKey,
        params: {
          scopeId,
          entityId,
          banner: _constants3.GENERIC_ENTITY_PREVIEW_BANNER
        }
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: scopeId,
      panel: 'right'
    });
  }, [openFlyout, scopeId, entityId, telemetry]);
  const fullDetailsLink = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: openDocumentFlyout,
    target: "_blank",
    "data-test-subj": _constants.GENERIC_ENTITY_FLYOUT_FOOTER_DETAILS_LINK_TEST_SUBJ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.securitySolution.flyout.preview.genericEntityFullDetails', {
    defaultMessage: 'Show full entity details'
  })), [openDocumentFlyout]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": _constants.GENERIC_ENTITY_FLYOUT_FOOTER_TEST_SUBJ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, isPreviewMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 29
    }
  }, fullDetailsLink), showAssistant && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatByTitle, {
    showAssistantOverlay: showAssistantOverlay,
    text: _translations.ASK_AI_ASSISTANT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    isDisabled: !entityId,
    kqlQuery: `entity.id: "${entityId}" OR related.entity: "${entityId}"`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  })))));
};
exports.GenericEntityFlyoutFooter = GenericEntityFlyoutFooter;