"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostPreviewPanelKey = exports.HostPanel = exports.HOST_PANEL_RISK_SCORE_QUERY_ID = exports.HOST_PANEL_OBSERVED_HOST_QUERY_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _use_has_vulnerabilities = require("@kbn/cloud-security-posture/src/hooks/use_has_vulnerabilities");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_non_closed_alerts = require("../../../cloud_security_posture/hooks/use_non_closed_alerts");
var _types = require("../../../overview/components/detection_response/alerts_by_status/types");
var _use_refetch_query_by_id = require("../../../entity_analytics/api/hooks/use_refetch_query_by_id");
var _risk_inputs_tab = require("../../../entity_analytics/components/entity_details_flyout/tabs/risk_inputs/risk_inputs_tab");
var _use_calculate_entity_risk_score = require("../../../entity_analytics/api/hooks/use_calculate_entity_risk_score");
var _host_to_criteria = require("../../../common/components/ml/criteria/host_to_criteria");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _manage_query = require("../../../common/components/page/manage_query");
var _use_global_time = require("../../../common/containers/use_global_time");
var _search_strategy = require("../../../../common/search_strategy");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _footer = require("./footer");
var _content = require("./content");
var _header = require("./header");
var _anomaly_table_provider = require("../../../common/components/ml/anomaly/anomaly_table_provider");
var _use_observed_host = require("./hooks/use_observed_host");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _footer2 = require("../host_preview/footer");
var _use_navigate_to_host_details = require("./hooks/use_navigate_to_host_details");
var _types2 = require("../../../../common/entity_analytics/types");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/host_right/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HostPreviewPanelKey = exports.HostPreviewPanelKey = 'host-preview-panel';
const HOST_PANEL_RISK_SCORE_QUERY_ID = exports.HOST_PANEL_RISK_SCORE_QUERY_ID = 'HostPanelRiskScoreQuery';
const HOST_PANEL_OBSERVED_HOST_QUERY_ID = exports.HOST_PANEL_OBSERVED_HOST_QUERY_ID = 'HostPanelObservedHostQuery';
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const HostPanel = ({
  contextID,
  scopeId,
  hostName,
  isPreviewMode
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const assetInventoryEnabled = uiSettings.get(_constants.ENABLE_ASSET_INVENTORY_SETTING, true);
  const {
    to,
    from,
    isInitializing,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const hostNameFilterQuery = (0, _react.useMemo)(() => hostName ? (0, _search_strategy.buildHostNamesFilter)([hostName]) : undefined, [hostName]);
  const riskScoreState = (0, _use_risk_score.useRiskScore)({
    riskEntity: _types2.EntityType.host,
    filterQuery: hostNameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION
  });
  const {
    data: hostRisk,
    inspect: inspectRiskScore,
    refetch,
    loading
  } = riskScoreState;
  const hostRiskData = hostRisk && hostRisk.length > 0 ? hostRisk[0] : undefined;
  const isRiskScoreExist = !!(hostRiskData !== null && hostRiskData !== void 0 && hostRiskData.host.risk);
  const refetchRiskInputsTab = (0, _use_refetch_query_by_id.useRefetchQueryById)(_risk_inputs_tab.RISK_INPUTS_TAB_QUERY_ID);
  const refetchRiskScore = (0, _react.useCallback)(() => {
    refetch();
    refetchRiskInputsTab === null || refetchRiskInputsTab === void 0 ? void 0 : refetchRiskInputsTab();
  }, [refetch, refetchRiskInputsTab]);
  const {
    isLoading: recalculatingScore,
    calculateEntityRiskScore
  } = (0, _use_calculate_entity_risk_score.useCalculateEntityRiskScore)(_types2.EntityType.host, hostName, {
    onSuccess: refetchRiskScore
  });
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)('host.name', hostName);
  const {
    hasVulnerabilitiesFindings
  } = (0, _use_has_vulnerabilities.useHasVulnerabilities)('host.name', hostName);
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field: _types2.EntityIdentifierFields.hostName,
    value: hostName,
    to,
    from,
    queryId: `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}HOST_NAME_RIGHT`
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectRiskScore,
    loading,
    queryId: HOST_PANEL_RISK_SCORE_QUERY_ID,
    refetch,
    setQuery
  });
  const {
    openDetailsPanel,
    isLinkEnabled
  } = (0, _use_navigate_to_host_details.useNavigateToHostDetails)({
    hostName,
    scopeId,
    isRiskScoreExist,
    hasMisconfigurationFindings,
    hasVulnerabilitiesFindings,
    hasNonClosedAlerts,
    isPreviewMode,
    contextID
  });
  const openDefaultPanel = (0, _react.useCallback)(() => openDetailsPanel({
    tab: isRiskScoreExist ? _left_panel_header.EntityDetailsLeftPanelTab.RISK_INPUTS : _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS
  }), [isRiskScoreExist, openDetailsPanel]);
  const observedHost = (0, _use_observed_host.useObservedHost)(hostName, scopeId);
  if (observedHost.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(observedHost.details),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => {
    const observedHostWithAnomalies = {
      ...observedHost,
      anomalies: {
        isLoading: isLoadingAnomaliesData,
        anomalies: anomaliesData,
        jobNameById
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
      flyoutIsExpandable: isRiskScoreExist || hasMisconfigurationFindings || hasVulnerabilitiesFindings || hasNonClosedAlerts,
      expandDetails: openDefaultPanel,
      isPreviewMode: isPreviewMode,
      isRulePreview: scopeId === _securitysolutionDataTable.TableId.rulePreview,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_header.HostPanelHeader, {
      hostName: hostName,
      observedHost: observedHostWithAnomalies,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_content.HostPanelContent, {
      hostName: hostName,
      observedHost: observedHostWithAnomalies,
      riskScoreState: riskScoreState,
      contextID: contextID,
      scopeId: scopeId,
      openDetailsPanel: openDetailsPanel,
      isLinkEnabled: isLinkEnabled,
      recalculatingScore: recalculatingScore,
      onAssetCriticalityChange: calculateEntityRiskScore,
      isPreviewMode: isPreviewMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 13
      }
    }), isPreviewMode && /*#__PURE__*/_react.default.createElement(_footer2.HostPreviewPanelFooter, {
      hostName: hostName,
      contextID: contextID,
      scopeId: scopeId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 15
      }
    }), !isPreviewMode && assetInventoryEnabled && /*#__PURE__*/_react.default.createElement(_footer.HostPanelFooter, {
      hostName: hostName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 57
      }
    }));
  });
};
exports.HostPanel = HostPanel;
HostPanel.displayName = 'HostPanel';