"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardComments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _get_formatted_comments = require("../utils/get_formatted_comments");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_entry_card/components/card_comments.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CardComments = exports.CardComments = /*#__PURE__*/(0, _react.memo)(({
  comments,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [showComments, setShowComments] = (0, _react.useState)(false);
  const onCommentsClick = (0, _react.useCallback)(() => {
    setShowComments(!showComments);
  }, [setShowComments, showComments]);
  const formattedComments = (0, _react.useMemo)(() => {
    return (0, _get_formatted_comments.getFormattedComments)(comments);
  }, [comments]);
  const buttonText = (0, _react.useMemo)(() => showComments ? (0, _translations.HIDE_COMMENTS_LABEL)(comments.length) : (0, _translations.SHOW_COMMENTS_LABEL)(comments.length), [comments.length, showComments]);
  return !(0, _fp.isEmpty)(comments) ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCommentsClick,
    flush: "left",
    size: "xs",
    "data-test-subj": getTestId('label'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, buttonText), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '1',
    arrowDisplay: "none",
    forceState: showComments ? 'open' : 'closed',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    comments: formattedComments,
    "data-test-subj": getTestId('list'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }))) : null;
});
CardComments.displayName = 'CardComments';