"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HELP_LABEL = exports.ConsoleHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_console_state_dispatch = require("../hooks/state_selectors/use_console_state_dispatch");
var _use_with_side_panel = require("../hooks/state_selectors/use_with_side_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/console_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HELP_LABEL = exports.HELP_LABEL = _i18n.i18n.translate('xpack.securitySolution.console.layoutHeader.helpButtonTitle', {
  defaultMessage: 'Help'
});
const HELP_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.console.layoutHeader.helpButtonLabel', {
  defaultMessage: 'Show help'
});
const StyledEuiButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  margin-left: auto;
  height: inherit;
`;
const ConsoleHeader = exports.ConsoleHeader = /*#__PURE__*/(0, _react.memo)(({
  TitleComponent
}) => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const panelCurrentlyShowing = (0, _use_with_side_panel.useWithSidePanel)().show;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)('header'));
  const isHelpOpen = panelCurrentlyShowing === 'help';
  const handleHelpButtonOnClick = (0, _react.useCallback)(() => {
    dispatch({
      type: 'showSidePanel',
      payload: {
        show: isHelpOpen ? null : 'help'
      }
    });
  }, [dispatch, isHelpOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "eui-textTruncate noThemeOverrides",
    css: {
      maxWidth: '95%'
    },
    "data-test-subj": getTestId('titleComponentContainer'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, TitleComponent ? /*#__PURE__*/_react.default.createElement(TitleComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 27
    }
  }) : ''), !isHelpOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiButtonEmpty, {
    css: {
      marginLeft: 'auto'
    },
    onClick: handleHelpButtonOnClick,
    iconType: "question",
    title: HELP_TOOLTIP,
    "aria-label": HELP_TOOLTIP,
    isSelected: isHelpOpen,
    "data-test-subj": getTestId('helpButton'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.console.layoutHeader.helpButtonTitle",
    defaultMessage: "Help",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }))));
});
ConsoleHeader.displayName = 'ConsoleHeader';