"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryOutput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _command_execution_output = require("./command_execution_output");
var _use_command_history = require("../hooks/state_selectors/use_command_history");
var _use_console_state_dispatch = require("../hooks/state_selectors/use_console_state_dispatch");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _history_item = require("./history_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/history_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HistoryOutput = exports.HistoryOutput = /*#__PURE__*/(0, _react.memo)(commonProps => {
  const historyItems = (0, _use_command_history.useCommandHistory)();
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const historyBody = (0, _react.useMemo)(() => {
    return historyItems.map(historyItem => {
      return /*#__PURE__*/_react.default.createElement(_history_item.HistoryItem, {
        key: historyItem.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_command_execution_output.CommandExecutionOutput, {
        item: historyItem,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 11
        }
      }));
    });
  }, [historyItems]);

  // Anytime we add a new item to the history
  // scroll down so that command input remains visible
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'scrollDown'
    });
  }, [dispatch, historyItems.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    "data-test-subj": getTestId('historyOutput')
  }, commonProps, {
    wrap: true,
    direction: "column",
    alignItems: "stretch",
    responsive: false,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }), historyBody);
});
HistoryOutput.displayName = 'HistoryOutput';