"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsAssignableList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _artifact_entry_card = require("../../../../../components/artifact_entry_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/artifacts/assignable/policy_artifacts_assignable_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyArtifactsAssignableList = exports.PolicyArtifactsAssignableList = /*#__PURE__*/_react.default.memo(({
  artifacts,
  isListLoading,
  selectedArtifactIds,
  selectedArtifactsUpdated,
  CardDecorator
}) => {
  const selectedArtifactIdsByKey = (0, _react.useMemo)(() => selectedArtifactIds.reduce((acc, current) => ({
    ...acc,
    [current]: true
  }), {}), [selectedArtifactIds]);
  const assignableList = (0, _react.useMemo)(() => {
    if (!artifacts || !artifacts.data.length) return null;
    const items = artifacts.data;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "artifactsList",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, items.map(artifact => /*#__PURE__*/_react.default.createElement(_artifact_entry_card.ArtifactEntryCardMinified, {
      key: artifact.id,
      item: artifact,
      isSelected: selectedArtifactIdsByKey[artifact.id] || false,
      onToggleSelectedArtifact: selected => selectedArtifactsUpdated(artifact.id, selected),
      Decorator: CardDecorator,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    })));
  }, [CardDecorator, artifacts, selectedArtifactIdsByKey, selectedArtifactsUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isListLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    "data-test-subj": "artifactsAssignableListLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, assignableList));
});
PolicyArtifactsAssignableList.displayName = 'PolicyArtifactsAssignableList';